/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Details of an operation to perform on a field.")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FieldUpdateOperation {
    @JsonProperty(value="add")
    private Object add = null;
    @JsonProperty(value="set")
    private Object set = null;
    @JsonProperty(value="remove")
    private Object remove = null;
    @JsonProperty(value="edit")
    private Object edit = null;

    public FieldUpdateOperation add(Object add) {
        this.add = add;
        return this;
    }

    @ApiModelProperty(example="{\"labels\":\"Training\",\"issuelinks\":{\"id\":10001}}", value="A map containing the name of a field and the value to add to it.")
    public Object getAdd() {
        return this.add;
    }

    public void setAdd(Object add) {
        this.add = add;
    }

    public FieldUpdateOperation set(Object set) {
        this.set = set;
        return this;
    }

    @ApiModelProperty(example="{\"summary\":\"A new summary\",\"issuetype\":{\"id\":10010}}", value="A map containing the name of a field and the value to set in it.")
    public Object getSet() {
        return this.set;
    }

    public void setSet(Object set) {
        this.set = set;
    }

    public FieldUpdateOperation remove(Object remove) {
        this.remove = remove;
        return this;
    }

    @ApiModelProperty(example="{\"labels\":\"Training\",\"components\":{\"id\":10017}}", value="A map containing the name of a field and the value to removed from it.")
    public Object getRemove() {
        return this.remove;
    }

    public void setRemove(Object remove) {
        this.remove = remove;
    }

    public FieldUpdateOperation edit(Object edit) {
        this.edit = edit;
        return this;
    }

    @ApiModelProperty(example="{\"timetracking\":{\"key\":\"JIRA\"}}", value="A map containing the name of a field and the value to edit in it.")
    public Object getEdit() {
        return this.edit;
    }

    public void setEdit(Object edit) {
        this.edit = edit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldUpdateOperation fieldUpdateOperation = (FieldUpdateOperation)o;
        return Objects.equals(this.add, fieldUpdateOperation.add) && Objects.equals(this.set, fieldUpdateOperation.set) && Objects.equals(this.remove, fieldUpdateOperation.remove) && Objects.equals(this.edit, fieldUpdateOperation.edit);
    }

    public int hashCode() {
        return Objects.hash(this.add, this.set, this.remove, this.edit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FieldUpdateOperation {\n");
        sb.append("    add: ").append(this.toIndentedString(this.add)).append("\n");
        sb.append("    set: ").append(this.toIndentedString(this.set)).append("\n");
        sb.append("    remove: ").append(this.toIndentedString(this.remove)).append("\n");
        sb.append("    edit: ").append(this.toIndentedString(this.edit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

