/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.SharePermission;

@ApiModel(description="Details of a dashboard.")
public class DashboardDetails {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="sharePermissions")
    private List<SharePermission> sharePermissions = new ArrayList<SharePermission>();
    @JsonProperty(value="editPermissions")
    private List<SharePermission> editPermissions = new ArrayList<SharePermission>();

    public DashboardDetails name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the dashboard.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DashboardDetails description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the dashboard.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DashboardDetails sharePermissions(List<SharePermission> sharePermissions) {
        this.sharePermissions = sharePermissions;
        return this;
    }

    public DashboardDetails addSharePermissionsItem(SharePermission sharePermissionsItem) {
        this.sharePermissions.add(sharePermissionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The share permissions for the dashboard.")
    public List<SharePermission> getSharePermissions() {
        return this.sharePermissions;
    }

    public void setSharePermissions(List<SharePermission> sharePermissions) {
        this.sharePermissions = sharePermissions;
    }

    public DashboardDetails editPermissions(List<SharePermission> editPermissions) {
        this.editPermissions = editPermissions;
        return this;
    }

    public DashboardDetails addEditPermissionsItem(SharePermission editPermissionsItem) {
        this.editPermissions.add(editPermissionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The edit permissions for the dashboard.")
    public List<SharePermission> getEditPermissions() {
        return this.editPermissions;
    }

    public void setEditPermissions(List<SharePermission> editPermissions) {
        this.editPermissions = editPermissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashboardDetails dashboardDetails = (DashboardDetails)o;
        return Objects.equals(this.name, dashboardDetails.name) && Objects.equals(this.description, dashboardDetails.description) && Objects.equals(this.sharePermissions, dashboardDetails.sharePermissions) && Objects.equals(this.editPermissions, dashboardDetails.editPermissions);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.sharePermissions, this.editPermissions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DashboardDetails {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    sharePermissions: ").append(this.toIndentedString(this.sharePermissions)).append("\n");
        sb.append("    editPermissions: ").append(this.toIndentedString(this.editPermissions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

