/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Value of a custom field option and the values of its cascading options.")
public class CustomFieldOptionValue {
    @JsonProperty(value="value")
    private String value;
    @JsonProperty(value="cascadingOptions")
    private List<String> cascadingOptions = new ArrayList<String>();

    public CustomFieldOptionValue value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="The value of the custom field option.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public CustomFieldOptionValue cascadingOptions(List<String> cascadingOptions) {
        this.cascadingOptions = cascadingOptions;
        return this;
    }

    public CustomFieldOptionValue addCascadingOptionsItem(String cascadingOptionsItem) {
        if (this.cascadingOptions == null) {
            this.cascadingOptions = new ArrayList<String>();
        }
        this.cascadingOptions.add(cascadingOptionsItem);
        return this;
    }

    @ApiModelProperty(value="The cascading options.")
    public List<String> getCascadingOptions() {
        return this.cascadingOptions;
    }

    public void setCascadingOptions(List<String> cascadingOptions) {
        this.cascadingOptions = cascadingOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomFieldOptionValue customFieldOptionValue = (CustomFieldOptionValue)o;
        return Objects.equals(this.value, customFieldOptionValue.value) && Objects.equals(this.cascadingOptions, customFieldOptionValue.cascadingOptions);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.cascadingOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomFieldOptionValue {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    cascadingOptions: ").append(this.toIndentedString(this.cascadingOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

