/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Details of a custom field option to create.")
public class CustomFieldOptionCreate {
    @JsonProperty(value="value")
    private String value;
    @JsonProperty(value="optionId")
    private String optionId;
    @JsonProperty(value="disabled")
    private Boolean disabled;

    public CustomFieldOptionCreate value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="The value of the custom field option.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public CustomFieldOptionCreate optionId(String optionId) {
        this.optionId = optionId;
        return this;
    }

    @ApiModelProperty(value="For cascading options, the ID of the custom field object containing the cascading option.")
    public String getOptionId() {
        return this.optionId;
    }

    public void setOptionId(String optionId) {
        this.optionId = optionId;
    }

    public CustomFieldOptionCreate disabled(Boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    @ApiModelProperty(value="Whether the option is disabled.")
    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomFieldOptionCreate customFieldOptionCreate = (CustomFieldOptionCreate)o;
        return Objects.equals(this.value, customFieldOptionCreate.value) && Objects.equals(this.optionId, customFieldOptionCreate.optionId) && Objects.equals(this.disabled, customFieldOptionCreate.disabled);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.optionId, this.disabled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomFieldOptionCreate {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    optionId: ").append(this.toIndentedString(this.optionId)).append("\n");
        sb.append("    disabled: ").append(this.toIndentedString(this.disabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

