/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Details about the project.")
public class CreateProjectDetails {
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="lead")
    private String lead;
    @JsonProperty(value="leadAccountId")
    private String leadAccountId;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="assigneeType")
    private AssigneeTypeEnum assigneeType;
    @JsonProperty(value="avatarId")
    private Long avatarId;
    @JsonProperty(value="issueSecurityScheme")
    private Long issueSecurityScheme;
    @JsonProperty(value="permissionScheme")
    private Long permissionScheme;
    @JsonProperty(value="notificationScheme")
    private Long notificationScheme;
    @JsonProperty(value="categoryId")
    private Long categoryId;
    @JsonProperty(value="projectTypeKey")
    private ProjectTypeKeyEnum projectTypeKey;
    @JsonProperty(value="projectTemplateKey")
    private ProjectTemplateKeyEnum projectTemplateKey;
    @JsonProperty(value="workflowScheme")
    private Long workflowScheme;
    @JsonProperty(value="issueTypeScreenScheme")
    private Long issueTypeScreenScheme;
    @JsonProperty(value="issueTypeScheme")
    private Long issueTypeScheme;
    @JsonProperty(value="fieldConfigurationScheme")
    private Long fieldConfigurationScheme;

    public CreateProjectDetails key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(required=true, value="Project keys must be unique and start with an uppercase letter followed by one or more uppercase alphanumeric characters. The maximum length is 10 characters.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public CreateProjectDetails name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the project.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateProjectDetails description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A brief description of the project.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateProjectDetails lead(String lead) {
        this.lead = lead;
        return this;
    }

    @ApiModelProperty(value="This parameter is deprecated because of privacy changes. Use `leadAccountId` instead. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details. The user name of the project lead. Either `lead` or `leadAccountId` must be set when creating a project. Cannot be provided with `leadAccountId`.")
    public String getLead() {
        return this.lead;
    }

    public void setLead(String lead) {
        this.lead = lead;
    }

    public CreateProjectDetails leadAccountId(String leadAccountId) {
        this.leadAccountId = leadAccountId;
        return this;
    }

    @ApiModelProperty(value="The account ID of the project lead. Either `lead` or `leadAccountId` must be set when creating a project. Cannot be provided with `lead`.")
    public String getLeadAccountId() {
        return this.leadAccountId;
    }

    public void setLeadAccountId(String leadAccountId) {
        this.leadAccountId = leadAccountId;
    }

    public CreateProjectDetails url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="A link to information about this project, such as project documentation")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public CreateProjectDetails assigneeType(AssigneeTypeEnum assigneeType) {
        this.assigneeType = assigneeType;
        return this;
    }

    @ApiModelProperty(value="The default assignee when creating issues for this project.")
    public AssigneeTypeEnum getAssigneeType() {
        return this.assigneeType;
    }

    public void setAssigneeType(AssigneeTypeEnum assigneeType) {
        this.assigneeType = assigneeType;
    }

    public CreateProjectDetails avatarId(Long avatarId) {
        this.avatarId = avatarId;
        return this;
    }

    @ApiModelProperty(value="An integer value for the project's avatar.")
    public Long getAvatarId() {
        return this.avatarId;
    }

    public void setAvatarId(Long avatarId) {
        this.avatarId = avatarId;
    }

    public CreateProjectDetails issueSecurityScheme(Long issueSecurityScheme) {
        this.issueSecurityScheme = issueSecurityScheme;
        return this;
    }

    @ApiModelProperty(value="The ID of the issue security scheme for the project, which enables you to control who can and cannot view issues. Use the [Get issue security schemes](#api-rest-api-2-issuesecurityschemes-get) resource to get all issue security scheme IDs.")
    public Long getIssueSecurityScheme() {
        return this.issueSecurityScheme;
    }

    public void setIssueSecurityScheme(Long issueSecurityScheme) {
        this.issueSecurityScheme = issueSecurityScheme;
    }

    public CreateProjectDetails permissionScheme(Long permissionScheme) {
        this.permissionScheme = permissionScheme;
        return this;
    }

    @ApiModelProperty(value="The ID of the permission scheme for the project. Use the [Get all permission schemes](#api-rest-api-2-permissionscheme-get) resource to see a list of all permission scheme IDs.")
    public Long getPermissionScheme() {
        return this.permissionScheme;
    }

    public void setPermissionScheme(Long permissionScheme) {
        this.permissionScheme = permissionScheme;
    }

    public CreateProjectDetails notificationScheme(Long notificationScheme) {
        this.notificationScheme = notificationScheme;
        return this;
    }

    @ApiModelProperty(value="The ID of the notification scheme for the project. Use the [Get notification schemes](#api-rest-api-2-notificationscheme-get) resource to get a list of notification scheme IDs.")
    public Long getNotificationScheme() {
        return this.notificationScheme;
    }

    public void setNotificationScheme(Long notificationScheme) {
        this.notificationScheme = notificationScheme;
    }

    public CreateProjectDetails categoryId(Long categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    @ApiModelProperty(value="The ID of the project's category. A complete list of category IDs is found using the [Get all project categories](#api-rest-api-2-projectCategory-get) operation.")
    public Long getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public CreateProjectDetails projectTypeKey(ProjectTypeKeyEnum projectTypeKey) {
        this.projectTypeKey = projectTypeKey;
        return this;
    }

    @ApiModelProperty(value="The [project type](https://confluence.atlassian.com/x/GwiiLQ#Jiraapplicationsoverview-Productfeaturesandprojecttypes), which defines the application-specific feature set. If you don't specify the project template you have to specify the project type.")
    public ProjectTypeKeyEnum getProjectTypeKey() {
        return this.projectTypeKey;
    }

    public void setProjectTypeKey(ProjectTypeKeyEnum projectTypeKey) {
        this.projectTypeKey = projectTypeKey;
    }

    public CreateProjectDetails projectTemplateKey(ProjectTemplateKeyEnum projectTemplateKey) {
        this.projectTemplateKey = projectTemplateKey;
        return this;
    }

    @ApiModelProperty(value="A predefined configuration for a project. The type of the `projectTemplateKey` must match with the type of the `projectTypeKey`.")
    public ProjectTemplateKeyEnum getProjectTemplateKey() {
        return this.projectTemplateKey;
    }

    public void setProjectTemplateKey(ProjectTemplateKeyEnum projectTemplateKey) {
        this.projectTemplateKey = projectTemplateKey;
    }

    public CreateProjectDetails workflowScheme(Long workflowScheme) {
        this.workflowScheme = workflowScheme;
        return this;
    }

    @ApiModelProperty(value="The ID of the workflow scheme for the project. Use the [Get all workflow schemes](#api-rest-api-2-workflowscheme-get) operation to get a list of workflow scheme IDs. If you specify the workflow scheme you cannot specify the project template key.")
    public Long getWorkflowScheme() {
        return this.workflowScheme;
    }

    public void setWorkflowScheme(Long workflowScheme) {
        this.workflowScheme = workflowScheme;
    }

    public CreateProjectDetails issueTypeScreenScheme(Long issueTypeScreenScheme) {
        this.issueTypeScreenScheme = issueTypeScreenScheme;
        return this;
    }

    @ApiModelProperty(value="The ID of the issue type screen scheme for the project. Use the [Get all issue type screen schemes](#api-rest-api-2-issuetypescreenscheme-get) operation to get a list of issue type screen scheme IDs. If you specify the issue type screen scheme you cannot specify the project template key.")
    public Long getIssueTypeScreenScheme() {
        return this.issueTypeScreenScheme;
    }

    public void setIssueTypeScreenScheme(Long issueTypeScreenScheme) {
        this.issueTypeScreenScheme = issueTypeScreenScheme;
    }

    public CreateProjectDetails issueTypeScheme(Long issueTypeScheme) {
        this.issueTypeScheme = issueTypeScheme;
        return this;
    }

    @ApiModelProperty(value="The ID of the issue type scheme for the project. Use the [Get all issue type schemes](#api-rest-api-2-issuetypescheme-get) operation to get a list of issue type scheme IDs. If you specify the issue type scheme you cannot specify the project template key.")
    public Long getIssueTypeScheme() {
        return this.issueTypeScheme;
    }

    public void setIssueTypeScheme(Long issueTypeScheme) {
        this.issueTypeScheme = issueTypeScheme;
    }

    public CreateProjectDetails fieldConfigurationScheme(Long fieldConfigurationScheme) {
        this.fieldConfigurationScheme = fieldConfigurationScheme;
        return this;
    }

    @ApiModelProperty(value="The ID of the field configuration scheme for the project. Use the [Get all field configuration schemes](#api-rest-api-2-fieldconfigurationscheme-get) operation to get a list of field configuration scheme IDs. If you specify the field configuration scheme you cannot specify the project template key.")
    public Long getFieldConfigurationScheme() {
        return this.fieldConfigurationScheme;
    }

    public void setFieldConfigurationScheme(Long fieldConfigurationScheme) {
        this.fieldConfigurationScheme = fieldConfigurationScheme;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateProjectDetails createProjectDetails = (CreateProjectDetails)o;
        return Objects.equals(this.key, createProjectDetails.key) && Objects.equals(this.name, createProjectDetails.name) && Objects.equals(this.description, createProjectDetails.description) && Objects.equals(this.lead, createProjectDetails.lead) && Objects.equals(this.leadAccountId, createProjectDetails.leadAccountId) && Objects.equals(this.url, createProjectDetails.url) && Objects.equals((Object)this.assigneeType, (Object)createProjectDetails.assigneeType) && Objects.equals(this.avatarId, createProjectDetails.avatarId) && Objects.equals(this.issueSecurityScheme, createProjectDetails.issueSecurityScheme) && Objects.equals(this.permissionScheme, createProjectDetails.permissionScheme) && Objects.equals(this.notificationScheme, createProjectDetails.notificationScheme) && Objects.equals(this.categoryId, createProjectDetails.categoryId) && Objects.equals((Object)this.projectTypeKey, (Object)createProjectDetails.projectTypeKey) && Objects.equals((Object)this.projectTemplateKey, (Object)createProjectDetails.projectTemplateKey) && Objects.equals(this.workflowScheme, createProjectDetails.workflowScheme) && Objects.equals(this.issueTypeScreenScheme, createProjectDetails.issueTypeScreenScheme) && Objects.equals(this.issueTypeScheme, createProjectDetails.issueTypeScheme) && Objects.equals(this.fieldConfigurationScheme, createProjectDetails.fieldConfigurationScheme);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.name, this.description, this.lead, this.leadAccountId, this.url, this.assigneeType, this.avatarId, this.issueSecurityScheme, this.permissionScheme, this.notificationScheme, this.categoryId, this.projectTypeKey, this.projectTemplateKey, this.workflowScheme, this.issueTypeScreenScheme, this.issueTypeScheme, this.fieldConfigurationScheme});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateProjectDetails {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    lead: ").append(this.toIndentedString(this.lead)).append("\n");
        sb.append("    leadAccountId: ").append(this.toIndentedString(this.leadAccountId)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    assigneeType: ").append(this.toIndentedString((Object)this.assigneeType)).append("\n");
        sb.append("    avatarId: ").append(this.toIndentedString(this.avatarId)).append("\n");
        sb.append("    issueSecurityScheme: ").append(this.toIndentedString(this.issueSecurityScheme)).append("\n");
        sb.append("    permissionScheme: ").append(this.toIndentedString(this.permissionScheme)).append("\n");
        sb.append("    notificationScheme: ").append(this.toIndentedString(this.notificationScheme)).append("\n");
        sb.append("    categoryId: ").append(this.toIndentedString(this.categoryId)).append("\n");
        sb.append("    projectTypeKey: ").append(this.toIndentedString((Object)this.projectTypeKey)).append("\n");
        sb.append("    projectTemplateKey: ").append(this.toIndentedString((Object)this.projectTemplateKey)).append("\n");
        sb.append("    workflowScheme: ").append(this.toIndentedString(this.workflowScheme)).append("\n");
        sb.append("    issueTypeScreenScheme: ").append(this.toIndentedString(this.issueTypeScreenScheme)).append("\n");
        sb.append("    issueTypeScheme: ").append(this.toIndentedString(this.issueTypeScheme)).append("\n");
        sb.append("    fieldConfigurationScheme: ").append(this.toIndentedString(this.fieldConfigurationScheme)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProjectTemplateKeyEnum {
        PYXIS_GREENHOPPER_JIRA_GH_SIMPLIFIED_AGILITY_KANBAN("com.pyxis.greenhopper.jira:gh-simplified-agility-kanban"),
        PYXIS_GREENHOPPER_JIRA_GH_SIMPLIFIED_AGILITY_SCRUM("com.pyxis.greenhopper.jira:gh-simplified-agility-scrum"),
        PYXIS_GREENHOPPER_JIRA_GH_SIMPLIFIED_BASIC("com.pyxis.greenhopper.jira:gh-simplified-basic"),
        PYXIS_GREENHOPPER_JIRA_GH_SIMPLIFIED_KANBAN_CLASSIC("com.pyxis.greenhopper.jira:gh-simplified-kanban-classic"),
        PYXIS_GREENHOPPER_JIRA_GH_SIMPLIFIED_SCRUM_CLASSIC("com.pyxis.greenhopper.jira:gh-simplified-scrum-classic"),
        ATLASSIAN_SERVICEDESK_SIMPLIFIED_IT_SERVICE_DESK("com.atlassian.servicedesk:simplified-it-service-desk"),
        ATLASSIAN_SERVICEDESK_SIMPLIFIED_INTERNAL_SERVICE_DESK("com.atlassian.servicedesk:simplified-internal-service-desk"),
        ATLASSIAN_SERVICEDESK_SIMPLIFIED_EXTERNAL_SERVICE_DESK("com.atlassian.servicedesk:simplified-external-service-desk"),
        ATLASSIAN_SERVICEDESK_SIMPLIFIED_HR_SERVICE_DESK("com.atlassian.servicedesk:simplified-hr-service-desk"),
        ATLASSIAN_SERVICEDESK_SIMPLIFIED_FACILITIES_SERVICE_DESK("com.atlassian.servicedesk:simplified-facilities-service-desk"),
        ATLASSIAN_JIRA_CORE_PROJECT_TEMPLATES_JIRA_CORE_SIMPLIFIED_CONTENT_MANAGEMENT("com.atlassian.jira-core-project-templates:jira-core-simplified-content-management"),
        ATLASSIAN_JIRA_CORE_PROJECT_TEMPLATES_JIRA_CORE_SIMPLIFIED_DOCUMENT_APPROVAL("com.atlassian.jira-core-project-templates:jira-core-simplified-document-approval"),
        ATLASSIAN_JIRA_CORE_PROJECT_TEMPLATES_JIRA_CORE_SIMPLIFIED_LEAD_TRACKING("com.atlassian.jira-core-project-templates:jira-core-simplified-lead-tracking"),
        ATLASSIAN_JIRA_CORE_PROJECT_TEMPLATES_JIRA_CORE_SIMPLIFIED_PROCESS_CONTROL("com.atlassian.jira-core-project-templates:jira-core-simplified-process-control"),
        ATLASSIAN_JIRA_CORE_PROJECT_TEMPLATES_JIRA_CORE_SIMPLIFIED_PROCUREMENT("com.atlassian.jira-core-project-templates:jira-core-simplified-procurement"),
        ATLASSIAN_JIRA_CORE_PROJECT_TEMPLATES_JIRA_CORE_SIMPLIFIED_PROJECT_MANAGEMENT("com.atlassian.jira-core-project-templates:jira-core-simplified-project-management"),
        ATLASSIAN_JIRA_CORE_PROJECT_TEMPLATES_JIRA_CORE_SIMPLIFIED_RECRUITMENT("com.atlassian.jira-core-project-templates:jira-core-simplified-recruitment"),
        ATLASSIAN_JIRA_CORE_PROJECT_TEMPLATES_JIRA_CORE_SIMPLIFIED_TASK_("com.atlassian.jira-core-project-templates:jira-core-simplified-task-");

        private String value;

        private ProjectTemplateKeyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProjectTemplateKeyEnum fromValue(String value) {
            for (ProjectTemplateKeyEnum b : ProjectTemplateKeyEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ProjectTypeKeyEnum {
        SOFTWARE("software"),
        SERVICE_DESK("service_desk"),
        BUSINESS("business");

        private String value;

        private ProjectTypeKeyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProjectTypeKeyEnum fromValue(String value) {
            for (ProjectTypeKeyEnum b : ProjectTypeKeyEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AssigneeTypeEnum {
        PROJECT_LEAD("PROJECT_LEAD"),
        UNASSIGNED("UNASSIGNED");

        private String value;

        private AssigneeTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AssigneeTypeEnum fromValue(String value) {
            for (AssigneeTypeEnum b : AssigneeTypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

