/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The details of a created custom field context.")
public class CreateCustomFieldContext {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="projectIds")
    private List<String> projectIds = new ArrayList<String>();
    @JsonProperty(value="issueTypeIds")
    private List<String> issueTypeIds = new ArrayList<String>();

    @ApiModelProperty(value="The ID of the context.")
    public String getId() {
        return this.id;
    }

    public CreateCustomFieldContext name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the context.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateCustomFieldContext description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the context.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateCustomFieldContext projectIds(List<String> projectIds) {
        this.projectIds = projectIds;
        return this;
    }

    public CreateCustomFieldContext addProjectIdsItem(String projectIdsItem) {
        if (this.projectIds == null) {
            this.projectIds = new ArrayList<String>();
        }
        this.projectIds.add(projectIdsItem);
        return this;
    }

    @ApiModelProperty(value="The list of project IDs associated with the context. If the list is empty, the context is global.")
    public List<String> getProjectIds() {
        return this.projectIds;
    }

    public void setProjectIds(List<String> projectIds) {
        this.projectIds = projectIds;
    }

    public CreateCustomFieldContext issueTypeIds(List<String> issueTypeIds) {
        this.issueTypeIds = issueTypeIds;
        return this;
    }

    public CreateCustomFieldContext addIssueTypeIdsItem(String issueTypeIdsItem) {
        if (this.issueTypeIds == null) {
            this.issueTypeIds = new ArrayList<String>();
        }
        this.issueTypeIds.add(issueTypeIdsItem);
        return this;
    }

    @ApiModelProperty(value="The list of issue types IDs for the context. If the list is empty, the context refers to all issue types.")
    public List<String> getIssueTypeIds() {
        return this.issueTypeIds;
    }

    public void setIssueTypeIds(List<String> issueTypeIds) {
        this.issueTypeIds = issueTypeIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCustomFieldContext createCustomFieldContext = (CreateCustomFieldContext)o;
        return Objects.equals(this.id, createCustomFieldContext.id) && Objects.equals(this.name, createCustomFieldContext.name) && Objects.equals(this.description, createCustomFieldContext.description) && Objects.equals(this.projectIds, createCustomFieldContext.projectIds) && Objects.equals(this.issueTypeIds, createCustomFieldContext.issueTypeIds);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.projectIds, this.issueTypeIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateCustomFieldContext {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    projectIds: ").append(this.toIndentedString(this.projectIds)).append("\n");
        sb.append("    issueTypeIds: ").append(this.toIndentedString(this.issueTypeIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

