/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.User;

@ApiModel(description="Details about a project component.")
public class Component {
    @JsonProperty(value="self")
    private URI self;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="lead")
    private User lead;
    @JsonProperty(value="leadUserName")
    private String leadUserName;
    @JsonProperty(value="leadAccountId")
    private String leadAccountId;
    @JsonProperty(value="assigneeType")
    private AssigneeTypeEnum assigneeType;
    @JsonProperty(value="assignee")
    private User assignee;
    @JsonProperty(value="realAssigneeType")
    private RealAssigneeTypeEnum realAssigneeType;
    @JsonProperty(value="realAssignee")
    private User realAssignee;
    @JsonProperty(value="isAssigneeTypeValid")
    private Boolean isAssigneeTypeValid;
    @JsonProperty(value="project")
    private String project;
    @JsonProperty(value="projectId")
    private Long projectId;

    @ApiModelProperty(value="The URL of the component.")
    public URI getSelf() {
        return this.self;
    }

    @ApiModelProperty(value="The unique identifier for the component.")
    public String getId() {
        return this.id;
    }

    public Component name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The unique name for the component in the project. Required when creating a component. Optional when updating a component. The maximum length is 255 characters.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Component description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description for the component. Optional when creating or updating a component.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(value="The user details for the component's lead user.")
    public User getLead() {
        return this.lead;
    }

    public Component leadUserName(String leadUserName) {
        this.leadUserName = leadUserName;
        return this;
    }

    @ApiModelProperty(value="This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.")
    public String getLeadUserName() {
        return this.leadUserName;
    }

    public void setLeadUserName(String leadUserName) {
        this.leadUserName = leadUserName;
    }

    public Component leadAccountId(String leadAccountId) {
        this.leadAccountId = leadAccountId;
        return this;
    }

    @ApiModelProperty(value="The accountId of the component's lead user. The accountId uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.")
    public String getLeadAccountId() {
        return this.leadAccountId;
    }

    public void setLeadAccountId(String leadAccountId) {
        this.leadAccountId = leadAccountId;
    }

    public Component assigneeType(AssigneeTypeEnum assigneeType) {
        this.assigneeType = assigneeType;
        return this;
    }

    @ApiModelProperty(value="The nominal user type used to determine the assignee for issues created with this component. See `realAssigneeType` for details on how the type of the user, and hence the user, assigned to issues is determined. Can take the following values:   *  `PROJECT_LEAD` the assignee to any issues created with this component is nominally the lead for the project the component is in.  *  `COMPONENT_LEAD` the assignee to any issues created with this component is nominally the lead for the component.  *  `UNASSIGNED` an assignee is not set for issues created with this component.  *  `PROJECT_DEFAULT` the assignee to any issues created with this component is nominally the default assignee for the project that the component is in.  Default value: `PROJECT_DEFAULT`.   Optional when creating or updating a component.")
    public AssigneeTypeEnum getAssigneeType() {
        return this.assigneeType;
    }

    public void setAssigneeType(AssigneeTypeEnum assigneeType) {
        this.assigneeType = assigneeType;
    }

    @ApiModelProperty(value="The details of the user associated with `assigneeType`, if any. See `realAssignee` for details of the user assigned to issues created with this component.")
    public User getAssignee() {
        return this.assignee;
    }

    @ApiModelProperty(value="The type of the assignee that is assigned to issues created with this component, when an assignee cannot be set from the `assigneeType`. For example, `assigneeType` is set to `COMPONENT_LEAD` but no component lead is set. This property is set to one of the following values:   *  `PROJECT_LEAD` when `assigneeType` is `PROJECT_LEAD` and the project lead has permission to be assigned issues in the project that the component is in.  *  `COMPONENT_LEAD` when `assignee`Type is `COMPONENT_LEAD` and the component lead has permission to be assigned issues in the project that the component is in.  *  `UNASSIGNED` when `assigneeType` is `UNASSIGNED` and Jira is configured to allow unassigned issues.  *  `PROJECT_DEFAULT` when none of the preceding cases are true.")
    public RealAssigneeTypeEnum getRealAssigneeType() {
        return this.realAssigneeType;
    }

    @ApiModelProperty(value="The user assigned to issues created with this component, when `assigneeType` does not identify a valid assignee.")
    public User getRealAssignee() {
        return this.realAssignee;
    }

    @ApiModelProperty(value="Whether a user is associated with `assigneeType`. For example, if the `assigneeType` is set to `COMPONENT_LEAD` but the component lead is not set, then `false` is returned.")
    public Boolean getIsAssigneeTypeValid() {
        return this.isAssigneeTypeValid;
    }

    public Component project(String project) {
        this.project = project;
        return this;
    }

    @ApiModelProperty(value="The key of the project the component is assigned to. Required when creating a component. Can't be updated.")
    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    @ApiModelProperty(value="The ID of the project the component is assigned to.")
    public Long getProjectId() {
        return this.projectId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Component component = (Component)o;
        return Objects.equals(this.self, component.self) && Objects.equals(this.id, component.id) && Objects.equals(this.name, component.name) && Objects.equals(this.description, component.description) && Objects.equals(this.lead, component.lead) && Objects.equals(this.leadUserName, component.leadUserName) && Objects.equals(this.leadAccountId, component.leadAccountId) && Objects.equals((Object)this.assigneeType, (Object)component.assigneeType) && Objects.equals(this.assignee, component.assignee) && Objects.equals((Object)this.realAssigneeType, (Object)component.realAssigneeType) && Objects.equals(this.realAssignee, component.realAssignee) && Objects.equals(this.isAssigneeTypeValid, component.isAssigneeTypeValid) && Objects.equals(this.project, component.project) && Objects.equals(this.projectId, component.projectId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.self, this.id, this.name, this.description, this.lead, this.leadUserName, this.leadAccountId, this.assigneeType, this.assignee, this.realAssigneeType, this.realAssignee, this.isAssigneeTypeValid, this.project, this.projectId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Component {\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    lead: ").append(this.toIndentedString(this.lead)).append("\n");
        sb.append("    leadUserName: ").append(this.toIndentedString(this.leadUserName)).append("\n");
        sb.append("    leadAccountId: ").append(this.toIndentedString(this.leadAccountId)).append("\n");
        sb.append("    assigneeType: ").append(this.toIndentedString((Object)this.assigneeType)).append("\n");
        sb.append("    assignee: ").append(this.toIndentedString(this.assignee)).append("\n");
        sb.append("    realAssigneeType: ").append(this.toIndentedString((Object)this.realAssigneeType)).append("\n");
        sb.append("    realAssignee: ").append(this.toIndentedString(this.realAssignee)).append("\n");
        sb.append("    isAssigneeTypeValid: ").append(this.toIndentedString(this.isAssigneeTypeValid)).append("\n");
        sb.append("    project: ").append(this.toIndentedString(this.project)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RealAssigneeTypeEnum {
        PROJECT_DEFAULT("PROJECT_DEFAULT"),
        COMPONENT_LEAD("COMPONENT_LEAD"),
        PROJECT_LEAD("PROJECT_LEAD"),
        UNASSIGNED("UNASSIGNED");

        private String value;

        private RealAssigneeTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RealAssigneeTypeEnum fromValue(String value) {
            for (RealAssigneeTypeEnum b : RealAssigneeTypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AssigneeTypeEnum {
        PROJECT_DEFAULT("PROJECT_DEFAULT"),
        COMPONENT_LEAD("COMPONENT_LEAD"),
        PROJECT_LEAD("PROJECT_LEAD"),
        UNASSIGNED("UNASSIGNED");

        private String value;

        private AssigneeTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AssigneeTypeEnum fromValue(String value) {
            for (AssigneeTypeEnum b : AssigneeTypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

