/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="List of project permissions and the projects and issues those permissions grant access to.")
public class BulkProjectPermissionGrants {
    @JsonProperty(value="permission")
    private String permission;
    @JsonProperty(value="issues")
    private List<Long> issues = new ArrayList<Long>();
    @JsonProperty(value="projects")
    private List<Long> projects = new ArrayList<Long>();

    public BulkProjectPermissionGrants permission(String permission) {
        this.permission = permission;
        return this;
    }

    @ApiModelProperty(required=true, value="A project permission,")
    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public BulkProjectPermissionGrants issues(List<Long> issues) {
        this.issues = issues;
        return this;
    }

    public BulkProjectPermissionGrants addIssuesItem(Long issuesItem) {
        this.issues.add(issuesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="IDs of the issues the user has the permission for.")
    public List<Long> getIssues() {
        return this.issues;
    }

    public void setIssues(List<Long> issues) {
        this.issues = issues;
    }

    public BulkProjectPermissionGrants projects(List<Long> projects) {
        this.projects = projects;
        return this;
    }

    public BulkProjectPermissionGrants addProjectsItem(Long projectsItem) {
        this.projects.add(projectsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="IDs of the projects the user has the permission for.")
    public List<Long> getProjects() {
        return this.projects;
    }

    public void setProjects(List<Long> projects) {
        this.projects = projects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkProjectPermissionGrants bulkProjectPermissionGrants = (BulkProjectPermissionGrants)o;
        return Objects.equals(this.permission, bulkProjectPermissionGrants.permission) && Objects.equals(this.issues, bulkProjectPermissionGrants.issues) && Objects.equals(this.projects, bulkProjectPermissionGrants.projects);
    }

    public int hashCode() {
        return Objects.hash(this.permission, this.issues, this.projects);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkProjectPermissionGrants {\n");
        sb.append("    permission: ").append(this.toIndentedString(this.permission)).append("\n");
        sb.append("    issues: ").append(this.toIndentedString(this.issues)).append("\n");
        sb.append("    projects: ").append(this.toIndentedString(this.projects)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

