/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Details of an avatar.")
public class Avatar {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="owner")
    private String owner;
    @JsonProperty(value="isSystemAvatar")
    private Boolean isSystemAvatar;
    @JsonProperty(value="isSelected")
    private Boolean isSelected;
    @JsonProperty(value="isDeletable")
    private Boolean isDeletable;
    @JsonProperty(value="fileName")
    private String fileName;
    @JsonProperty(value="urls")
    private Map<String, URI> urls = new HashMap<String, URI>();

    public Avatar id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the avatar.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(value="The owner of the avatar. For a system avatar the owner is null (and nothing is returned). For non-system avatars this is the appropriate identifier, such as the ID for a project or the account ID for a user.")
    public String getOwner() {
        return this.owner;
    }

    @ApiModelProperty(value="Whether the avatar is a system avatar.")
    public Boolean getIsSystemAvatar() {
        return this.isSystemAvatar;
    }

    @ApiModelProperty(value="Whether the avatar is used in Jira. For example, shown as a project's avatar.")
    public Boolean getIsSelected() {
        return this.isSelected;
    }

    @ApiModelProperty(value="Whether the avatar can be deleted.")
    public Boolean getIsDeletable() {
        return this.isDeletable;
    }

    @ApiModelProperty(value="The file name of the avatar icon. Returned for system avatars.")
    public String getFileName() {
        return this.fileName;
    }

    @ApiModelProperty(value="The list of avatar icon URLs.")
    public Map<String, URI> getUrls() {
        return this.urls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Avatar avatar = (Avatar)o;
        return Objects.equals(this.id, avatar.id) && Objects.equals(this.owner, avatar.owner) && Objects.equals(this.isSystemAvatar, avatar.isSystemAvatar) && Objects.equals(this.isSelected, avatar.isSelected) && Objects.equals(this.isDeletable, avatar.isDeletable) && Objects.equals(this.fileName, avatar.fileName) && Objects.equals(this.urls, avatar.urls);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.owner, this.isSystemAvatar, this.isSelected, this.isDeletable, this.fileName, this.urls);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Avatar {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    isSystemAvatar: ").append(this.toIndentedString(this.isSystemAvatar)).append("\n");
        sb.append("    isSelected: ").append(this.toIndentedString(this.isSelected)).append("\n");
        sb.append("    isDeletable: ").append(this.toIndentedString(this.isDeletable)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    urls: ").append(this.toIndentedString(this.urls)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

