/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.User;

@ApiModel(description="Metadata for an issue attachment.")
public class AttachmentMetadata {
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="self")
    private URI self;
    @JsonProperty(value="filename")
    private String filename;
    @JsonProperty(value="author")
    private User author;
    @JsonProperty(value="created")
    private OffsetDateTime created;
    @JsonProperty(value="size")
    private Long size;
    @JsonProperty(value="mimeType")
    private String mimeType;
    @JsonProperty(value="properties")
    private Map<String, Object> properties = new HashMap<String, Object>();
    @JsonProperty(value="content")
    private String content;
    @JsonProperty(value="thumbnail")
    private String thumbnail;

    @ApiModelProperty(value="The ID of the attachment.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The URL of the attachment metadata details.")
    public URI getSelf() {
        return this.self;
    }

    @ApiModelProperty(value="The name of the attachment file.")
    public String getFilename() {
        return this.filename;
    }

    @ApiModelProperty(value="Details of the user who attached the file.")
    public User getAuthor() {
        return this.author;
    }

    @ApiModelProperty(value="The datetime the attachment was created.")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @ApiModelProperty(value="The size of the attachment.")
    public Long getSize() {
        return this.size;
    }

    @ApiModelProperty(value="The MIME type of the attachment.")
    public String getMimeType() {
        return this.mimeType;
    }

    @ApiModelProperty(value="Additional properties of the attachment.")
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @ApiModelProperty(value="The URL of the attachment.")
    public String getContent() {
        return this.content;
    }

    @ApiModelProperty(value="The URL of a thumbnail representing the attachment.")
    public String getThumbnail() {
        return this.thumbnail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentMetadata attachmentMetadata = (AttachmentMetadata)o;
        return Objects.equals(this.id, attachmentMetadata.id) && Objects.equals(this.self, attachmentMetadata.self) && Objects.equals(this.filename, attachmentMetadata.filename) && Objects.equals(this.author, attachmentMetadata.author) && Objects.equals(this.created, attachmentMetadata.created) && Objects.equals(this.size, attachmentMetadata.size) && Objects.equals(this.mimeType, attachmentMetadata.mimeType) && Objects.equals(this.properties, attachmentMetadata.properties) && Objects.equals(this.content, attachmentMetadata.content) && Objects.equals(this.thumbnail, attachmentMetadata.thumbnail);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.self, this.filename, this.author, this.created, this.size, this.mimeType, this.properties, this.content, this.thumbnail);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AttachmentMetadata {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    filename: ").append(this.toIndentedString(this.filename)).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    mimeType: ").append(this.toIndentedString(this.mimeType)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    thumbnail: ").append(this.toIndentedString(this.thumbnail)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

