/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.AttachmentArchiveItemReadable;

@ApiModel(description="Metadata for an archive (for example a zip) and its contents.")
public class AttachmentArchiveMetadataReadable {
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="entries")
    private List<AttachmentArchiveItemReadable> entries = new ArrayList<AttachmentArchiveItemReadable>();
    @JsonProperty(value="totalEntryCount")
    private Long totalEntryCount;
    @JsonProperty(value="mediaType")
    private String mediaType;

    @ApiModelProperty(value="The ID of the attachment.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The name of the archive file.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The list of the items included in the archive.")
    public List<AttachmentArchiveItemReadable> getEntries() {
        return this.entries;
    }

    @ApiModelProperty(value="The number of items included in the archive.")
    public Long getTotalEntryCount() {
        return this.totalEntryCount;
    }

    @ApiModelProperty(value="The MIME type of the attachment.")
    public String getMediaType() {
        return this.mediaType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentArchiveMetadataReadable attachmentArchiveMetadataReadable = (AttachmentArchiveMetadataReadable)o;
        return Objects.equals(this.id, attachmentArchiveMetadataReadable.id) && Objects.equals(this.name, attachmentArchiveMetadataReadable.name) && Objects.equals(this.entries, attachmentArchiveMetadataReadable.entries) && Objects.equals(this.totalEntryCount, attachmentArchiveMetadataReadable.totalEntryCount) && Objects.equals(this.mediaType, attachmentArchiveMetadataReadable.mediaType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.entries, this.totalEntryCount, this.mediaType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AttachmentArchiveMetadataReadable {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    entries: ").append(this.toIndentedString(this.entries)).append("\n");
        sb.append("    totalEntryCount: ").append(this.toIndentedString(this.totalEntryCount)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString(this.mediaType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

