/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="The application the linked item is in.")
public class Application {
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="name")
    private String name;
    private HashMap<String, Object> additionalProperties_ = new HashMap();

    public Application type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The name-spaced type of the application, used by registered rendering apps.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Application name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the application. Used in conjunction with the (remote) object icon title to display a tooltip for the link's icon. The tooltip takes the format \"\\[application name\\] icon title\". Blank items are excluded from the tooltip title. If both items are blank, the icon tooltop displays as \"Web Link\". Grouping and sorting of links may place links without an application name last.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.additionalProperties_;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.additionalProperties_.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Application application = (Application)o;
        return Objects.equals(this.type, application.type) && Objects.equals(this.name, application.name) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Application {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties_)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

