/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanScreen;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanScreenWithTab;
import org.everit.atlassian.restclient.jiracloud.v2.model.Screen;
import org.everit.atlassian.restclient.jiracloud.v2.model.ScreenDetails;
import org.everit.atlassian.restclient.jiracloud.v2.model.ScreenableField;
import org.everit.atlassian.restclient.jiracloud.v2.model.UpdateScreenDetails;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestClientUtil;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class ScreensApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.net";
    private static final TypeReference<Object> returnType_addFieldToDefaultScreen = new TypeReference<Object>(){};
    private static final TypeReference<Screen> returnType_createScreen = new TypeReference<Screen>(){};
    private static final TypeReference<List<ScreenableField>> returnType_getAvailableScreenFields = new TypeReference<List<ScreenableField>>(){};
    private static final TypeReference<PageBeanScreen> returnType_getScreens = new TypeReference<PageBeanScreen>(){};
    private static final TypeReference<PageBeanScreenWithTab> returnType_getScreensForField = new TypeReference<PageBeanScreenWithTab>(){};
    private static final TypeReference<Screen> returnType_updateScreen = new TypeReference<Screen>(){};
    private final RestClient restClient;

    public ScreensApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<Object> addFieldToDefaultScreen(String fieldId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screens/addToDefault/{fieldId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldId", String.valueOf(fieldId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_addFieldToDefaultScreen);
    }

    public Single<Screen> createScreen(ScreenDetails screenDetails, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screens");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(screenDetails));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createScreen);
    }

    public Completable deleteScreen(Long screenId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screens/{screenId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenId", String.valueOf(screenId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<List<ScreenableField>> getAvailableScreenFields(Long screenId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screens/{screenId}/availableFields");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenId", String.valueOf(screenId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAvailableScreenFields);
    }

    public Single<PageBeanScreen> getScreens(Optional<Long> startAt, Optional<Integer> maxResults, Optional<List<Long>> id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screens");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (id.isPresent()) {
            queryParams.put("id", RestClientUtil.objectCollectionToStringCollection((Collection)id.get()));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getScreens);
    }

    public Single<PageBeanScreenWithTab> getScreensForField(String fieldId, Optional<Long> startAt, Optional<Integer> maxResults, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/field/{fieldId}/screens");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldId", String.valueOf(fieldId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getScreensForField);
    }

    public Single<Screen> updateScreen(Long screenId, UpdateScreenDetails updateScreenDetails, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screens/{screenId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenId", String.valueOf(screenId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(updateScreenDetails));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateScreen);
    }
}

