/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.BulkPermissionGrants;
import org.everit.atlassian.restclient.jiracloud.v2.model.BulkPermissionsRequestBean;
import org.everit.atlassian.restclient.jiracloud.v2.model.Permissions;
import org.everit.atlassian.restclient.jiracloud.v2.model.PermissionsKeysBean;
import org.everit.atlassian.restclient.jiracloud.v2.model.PermittedProjects;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class PermissionsApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.net";
    private static final TypeReference<Permissions> returnType_getAllPermissions = new TypeReference<Permissions>(){};
    private static final TypeReference<BulkPermissionGrants> returnType_getBulkPermissions = new TypeReference<BulkPermissionGrants>(){};
    private static final TypeReference<Permissions> returnType_getMyPermissions = new TypeReference<Permissions>(){};
    private static final TypeReference<PermittedProjects> returnType_getPermittedProjects = new TypeReference<PermittedProjects>(){};
    private final RestClient restClient;

    public PermissionsApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<Permissions> getAllPermissions(Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/permissions");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAllPermissions);
    }

    public Single<BulkPermissionGrants> getBulkPermissions(BulkPermissionsRequestBean bulkPermissionsRequestBean, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/permissions/check");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(bulkPermissionsRequestBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getBulkPermissions);
    }

    public Single<Permissions> getMyPermissions(Optional<String> projectKey, Optional<String> projectId, Optional<String> issueKey, Optional<String> issueId, Optional<String> permissions, Optional<String> projectUuid, Optional<String> projectConfigurationUuid, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/mypermissions");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (projectKey.isPresent()) {
            queryParams.put("projectKey", Collections.singleton(String.valueOf(projectKey.get())));
        }
        if (projectId.isPresent()) {
            queryParams.put("projectId", Collections.singleton(String.valueOf(projectId.get())));
        }
        if (issueKey.isPresent()) {
            queryParams.put("issueKey", Collections.singleton(String.valueOf(issueKey.get())));
        }
        if (issueId.isPresent()) {
            queryParams.put("issueId", Collections.singleton(String.valueOf(issueId.get())));
        }
        if (permissions.isPresent()) {
            queryParams.put("permissions", Collections.singleton(String.valueOf(permissions.get())));
        }
        if (projectUuid.isPresent()) {
            queryParams.put("projectUuid", Collections.singleton(String.valueOf(projectUuid.get())));
        }
        if (projectConfigurationUuid.isPresent()) {
            queryParams.put("projectConfigurationUuid", Collections.singleton(String.valueOf(projectConfigurationUuid.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getMyPermissions);
    }

    public Single<PermittedProjects> getPermittedProjects(PermissionsKeysBean permissionsKeysBean, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/permissions/project");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(permissionsKeysBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getPermittedProjects);
    }
}

