/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.PermissionGrant;
import org.everit.atlassian.restclient.jiracloud.v2.model.PermissionGrants;
import org.everit.atlassian.restclient.jiracloud.v2.model.PermissionScheme;
import org.everit.atlassian.restclient.jiracloud.v2.model.PermissionSchemes;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class PermissionSchemeApi {
    private static final String DEFAULT_BASE_PATH = "http://localhost";
    private static final TypeReference<PermissionGrant> returnType_createPermissionGrant = new TypeReference<PermissionGrant>(){};
    private static final TypeReference<PermissionScheme> returnType_createPermissionScheme = new TypeReference<PermissionScheme>(){};
    private static final TypeReference<PermissionSchemes> returnType_getAllPermissionSchemes = new TypeReference<PermissionSchemes>(){};
    private static final TypeReference<PermissionScheme> returnType_getPermissionScheme = new TypeReference<PermissionScheme>(){};
    private static final TypeReference<PermissionGrant> returnType_getPermissionSchemeGrant = new TypeReference<PermissionGrant>(){};
    private static final TypeReference<PermissionGrants> returnType_getPermissionSchemeGrants = new TypeReference<PermissionGrants>(){};
    private static final TypeReference<PermissionScheme> returnType_updatePermissionScheme = new TypeReference<PermissionScheme>(){};
    private final RestClient restClient;

    public PermissionSchemeApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<PermissionGrant> createPermissionGrant(Long schemeId, PermissionGrant permissionGrant, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/permissionscheme/{schemeId}/permission");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("schemeId", String.valueOf(schemeId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(permissionGrant));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createPermissionGrant);
    }

    public Single<PermissionScheme> createPermissionScheme(PermissionScheme requestBody, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/permissionscheme");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createPermissionScheme);
    }

    public Completable deletePermissionScheme(Long schemeId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/permissionscheme/{schemeId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("schemeId", String.valueOf(schemeId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Completable deletePermissionSchemeEntity(Long schemeId, Long permissionId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/permissionscheme/{schemeId}/permission/{permissionId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("schemeId", String.valueOf(schemeId));
        pathParams.put("permissionId", String.valueOf(permissionId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<PermissionSchemes> getAllPermissionSchemes(Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/permissionscheme");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAllPermissionSchemes);
    }

    public Single<PermissionScheme> getPermissionScheme(Long schemeId, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/permissionscheme/{schemeId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("schemeId", String.valueOf(schemeId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getPermissionScheme);
    }

    public Single<PermissionGrant> getPermissionSchemeGrant(Long schemeId, Long permissionId, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/permissionscheme/{schemeId}/permission/{permissionId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("schemeId", String.valueOf(schemeId));
        pathParams.put("permissionId", String.valueOf(permissionId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getPermissionSchemeGrant);
    }

    public Single<PermissionGrants> getPermissionSchemeGrants(Long schemeId, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/permissionscheme/{schemeId}/permission");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("schemeId", String.valueOf(schemeId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getPermissionSchemeGrants);
    }

    public Single<PermissionScheme> updatePermissionScheme(Long schemeId, PermissionScheme requestBody, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/permissionscheme/{schemeId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("schemeId", String.valueOf(schemeId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updatePermissionScheme);
    }
}

