/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.Avatar;
import org.everit.atlassian.restclient.jiracloud.v2.model.IssueTypeBean;
import org.everit.atlassian.restclient.jiracloud.v2.model.IssueTypeCreateBean;
import org.everit.atlassian.restclient.jiracloud.v2.model.IssueTypeUpdateBean;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class IssueTypeApi {
    private static final String DEFAULT_BASE_PATH = "http://localhost";
    private static final TypeReference<IssueTypeBean> returnType_createIssueType = new TypeReference<IssueTypeBean>(){};
    private static final TypeReference<Avatar> returnType_createIssueTypeAvatar = new TypeReference<Avatar>(){};
    private static final TypeReference<List<IssueTypeBean>> returnType_getAlternativeIssueTypes = new TypeReference<List<IssueTypeBean>>(){};
    private static final TypeReference<List<IssueTypeBean>> returnType_getIssueAllTypes = new TypeReference<List<IssueTypeBean>>(){};
    private static final TypeReference<IssueTypeBean> returnType_getIssueType = new TypeReference<IssueTypeBean>(){};
    private static final TypeReference<IssueTypeBean> returnType_updateIssueType = new TypeReference<IssueTypeBean>(){};
    private final RestClient restClient;

    public IssueTypeApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<IssueTypeBean> createIssueType(IssueTypeCreateBean issueTypeCreateBean, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuetype");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(issueTypeCreateBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createIssueType);
    }

    public Single<Avatar> createIssueTypeAvatar(String id, Object body, Optional<Integer> x, Optional<Integer> y, Optional<Integer> size, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuetype/{id}/avatar2");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (x.isPresent()) {
            queryParams.put("x", Collections.singleton(String.valueOf(x.get())));
        }
        if (y.isPresent()) {
            queryParams.put("y", Collections.singleton(String.valueOf(y.get())));
        }
        if (size.isPresent()) {
            queryParams.put("size", Collections.singleton(String.valueOf(size.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(body));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createIssueTypeAvatar);
    }

    public Completable deleteIssueType(String id, Optional<String> alternativeIssueTypeId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuetype/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (alternativeIssueTypeId.isPresent()) {
            queryParams.put("alternativeIssueTypeId", Collections.singleton(String.valueOf(alternativeIssueTypeId.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<List<IssueTypeBean>> getAlternativeIssueTypes(String id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuetype/{id}/alternatives");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAlternativeIssueTypes);
    }

    public Single<List<IssueTypeBean>> getIssueAllTypes(Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuetype");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getIssueAllTypes);
    }

    public Single<IssueTypeBean> getIssueType(String id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuetype/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getIssueType);
    }

    public Single<IssueTypeBean> updateIssueType(String id, IssueTypeUpdateBean issueTypeUpdateBean, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuetype/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(issueTypeUpdateBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateIssueType);
    }
}

