/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Single;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanIssueSecurityLevelMember;
import org.everit.atlassian.restclient.jiracloud.v2.model.SecurityLevel;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestClientUtil;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class IssueSecurityLevelApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.net";
    private static final TypeReference<SecurityLevel> returnType_getIssueSecurityLevel = new TypeReference<SecurityLevel>(){};
    private static final TypeReference<PageBeanIssueSecurityLevelMember> returnType_getIssueSecurityLevelMembers = new TypeReference<PageBeanIssueSecurityLevelMember>(){};
    private final RestClient restClient;

    public IssueSecurityLevelApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<SecurityLevel> getIssueSecurityLevel(String id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/securitylevel/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getIssueSecurityLevel);
    }

    public Single<PageBeanIssueSecurityLevelMember> getIssueSecurityLevelMembers(Long issueSecuritySchemeId, Optional<Long> startAt, Optional<Integer> maxResults, Optional<List<Long>> issueSecurityLevelId, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issuesecurityschemes/{issueSecuritySchemeId}/members");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueSecuritySchemeId", String.valueOf(issueSecuritySchemeId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (issueSecurityLevelId.isPresent()) {
            queryParams.put("issueSecurityLevelId", RestClientUtil.objectCollectionToStringCollection((Collection)issueSecurityLevelId.get()));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getIssueSecurityLevelMembers);
    }
}

