/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.IssueFieldOption;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanIssueFieldOption;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class IssueCustomFieldOptionsAppsApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.net";
    private static final TypeReference<IssueFieldOption> returnType_createIssueFieldOption = new TypeReference<IssueFieldOption>(){};
    private static final TypeReference<Object> returnType_deleteIssueFieldOption = new TypeReference<Object>(){};
    private static final TypeReference<PageBeanIssueFieldOption> returnType_getAllIssueFieldOptions = new TypeReference<PageBeanIssueFieldOption>(){};
    private static final TypeReference<IssueFieldOption> returnType_getIssueFieldOption = new TypeReference<IssueFieldOption>(){};
    private static final TypeReference<PageBeanIssueFieldOption> returnType_getSelectableIssueFieldOptions = new TypeReference<PageBeanIssueFieldOption>(){};
    private static final TypeReference<PageBeanIssueFieldOption> returnType_getVisibleIssueFieldOptions = new TypeReference<PageBeanIssueFieldOption>(){};
    private static final TypeReference<IssueFieldOption> returnType_updateIssueFieldOption = new TypeReference<IssueFieldOption>(){};
    private final RestClient restClient;

    public IssueCustomFieldOptionsAppsApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<IssueFieldOption> createIssueFieldOption(String fieldKey, Map<String, Object> requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/field/{fieldKey}/option");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldKey", String.valueOf(fieldKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createIssueFieldOption);
    }

    public Single<Object> deleteIssueFieldOption(String fieldKey, Long optionId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/field/{fieldKey}/option/{optionId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldKey", String.valueOf(fieldKey));
        pathParams.put("optionId", String.valueOf(optionId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_deleteIssueFieldOption);
    }

    public Single<PageBeanIssueFieldOption> getAllIssueFieldOptions(String fieldKey, Optional<Long> startAt, Optional<Integer> maxResults, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/field/{fieldKey}/option");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldKey", String.valueOf(fieldKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAllIssueFieldOptions);
    }

    public Single<IssueFieldOption> getIssueFieldOption(String fieldKey, Long optionId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/field/{fieldKey}/option/{optionId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldKey", String.valueOf(fieldKey));
        pathParams.put("optionId", String.valueOf(optionId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getIssueFieldOption);
    }

    public Single<PageBeanIssueFieldOption> getSelectableIssueFieldOptions(String fieldKey, Optional<Long> startAt, Optional<Integer> maxResults, Optional<Long> projectId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/field/{fieldKey}/option/suggestions/edit");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldKey", String.valueOf(fieldKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (projectId.isPresent()) {
            queryParams.put("projectId", Collections.singleton(String.valueOf(projectId.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getSelectableIssueFieldOptions);
    }

    public Single<PageBeanIssueFieldOption> getVisibleIssueFieldOptions(String fieldKey, Optional<Long> startAt, Optional<Integer> maxResults, Optional<Long> projectId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/field/{fieldKey}/option/suggestions/search");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldKey", String.valueOf(fieldKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (projectId.isPresent()) {
            queryParams.put("projectId", Collections.singleton(String.valueOf(projectId.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getVisibleIssueFieldOptions);
    }

    public Completable replaceIssueFieldOption(String fieldKey, Long optionId, Optional<Long> replaceWith, Optional<String> jql, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/field/{fieldKey}/option/{optionId}/issue");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldKey", String.valueOf(fieldKey));
        pathParams.put("optionId", String.valueOf(optionId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (replaceWith.isPresent()) {
            queryParams.put("replaceWith", Collections.singleton(String.valueOf(replaceWith.get())));
        }
        if (jql.isPresent()) {
            queryParams.put("jql", Collections.singleton(String.valueOf(jql.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<IssueFieldOption> updateIssueFieldOption(String fieldKey, Long optionId, IssueFieldOption issueFieldOption, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/field/{fieldKey}/option/{optionId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("fieldKey", String.valueOf(fieldKey));
        pathParams.put("optionId", String.valueOf(optionId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(issueFieldOption));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateIssueFieldOption);
    }
}

