/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.everit.atlassian.restclient.jiracloud.v2.model.ConnectCustomFieldValues;
import org.everit.atlassian.restclient.jiracloud.v2.model.EntityPropertyDetails;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowRulesSearch;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowRulesSearchDetails;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class AppMigrationApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.net";
    private static final TypeReference<Object> returnType_appIssueFieldValueUpdateResourceUpdateIssueFieldsPut = new TypeReference<Object>(){};
    private static final TypeReference<WorkflowRulesSearchDetails> returnType_migrationResourceWorkflowRuleSearchPost = new TypeReference<WorkflowRulesSearchDetails>(){};
    private final RestClient restClient;

    public AppMigrationApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<Object> appIssueFieldValueUpdateResourceUpdateIssueFieldsPut(String atlassianTransferId, String atlassianAccountId, ConnectCustomFieldValues connectCustomFieldValues, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/atlassian-connect/1/migration/field");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Atlassian-Transfer-Id", atlassianTransferId);
        headers.put("Atlassian-Account-Id", atlassianAccountId);
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(connectCustomFieldValues));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_appIssueFieldValueUpdateResourceUpdateIssueFieldsPut);
    }

    public Completable migrationResourceUpdateEntityPropertiesValuePut(String atlassianTransferId, String atlassianAccountId, String entityType, List<EntityPropertyDetails> entityPropertyDetails, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/atlassian-connect/1/migration/properties/{entityType}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("entityType", String.valueOf(entityType));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Atlassian-Transfer-Id", atlassianTransferId);
        headers.put("Atlassian-Account-Id", atlassianAccountId);
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(entityPropertyDetails));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<WorkflowRulesSearchDetails> migrationResourceWorkflowRuleSearchPost(String atlassianTransferId, WorkflowRulesSearch workflowRulesSearch, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/atlassian-connect/1/migration/workflow/rule/search");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Atlassian-Transfer-Id", atlassianTransferId);
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(workflowRulesSearch));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_migrationResourceWorkflowRuleSearchPost);
    }
}

