/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowTransitionRules;

/**
 * Details of workflow transition rules.
 */
@ApiModel(description = "Details of workflow transition rules.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-09-03T13:48:26.928+02:00[Europe/Prague]")
public class WorkflowRulesSearchDetails {
  @JsonProperty("workflowEntityId")
  private UUID workflowEntityId;

  @JsonProperty("invalidRules")
  private List<UUID> invalidRules = new ArrayList<>();

  @JsonProperty("validRules")
  private List<WorkflowTransitionRules> validRules = new ArrayList<>();

  public WorkflowRulesSearchDetails workflowEntityId(UUID workflowEntityId) {
    this.workflowEntityId = workflowEntityId;
    return this;
  }

   /**
   * The workflow ID.
   * @return workflowEntityId
  **/
  @ApiModelProperty(example = "a498d711-685d-428d-8c3e-bc03bb450ea7", value = "The workflow ID.")
  public UUID getWorkflowEntityId() {
    return workflowEntityId;
  }

  public void setWorkflowEntityId(UUID workflowEntityId) {
    this.workflowEntityId = workflowEntityId;
  }

  public WorkflowRulesSearchDetails invalidRules(List<UUID> invalidRules) {
    this.invalidRules = invalidRules;
    return this;
  }

  public WorkflowRulesSearchDetails addInvalidRulesItem(UUID invalidRulesItem) {
    if (this.invalidRules == null) {
      this.invalidRules = new ArrayList<>();
    }
    this.invalidRules.add(invalidRulesItem);
    return this;
  }

   /**
   * List of workflow rule IDs that do not belong to the workflow or can not be found.
   * @return invalidRules
  **/
  @ApiModelProperty(value = "List of workflow rule IDs that do not belong to the workflow or can not be found.")
  public List<UUID> getInvalidRules() {
    return invalidRules;
  }

  public void setInvalidRules(List<UUID> invalidRules) {
    this.invalidRules = invalidRules;
  }

  public WorkflowRulesSearchDetails validRules(List<WorkflowTransitionRules> validRules) {
    this.validRules = validRules;
    return this;
  }

  public WorkflowRulesSearchDetails addValidRulesItem(WorkflowTransitionRules validRulesItem) {
    if (this.validRules == null) {
      this.validRules = new ArrayList<>();
    }
    this.validRules.add(validRulesItem);
    return this;
  }

   /**
   * List of valid workflow transition rules.
   * @return validRules
  **/
  @ApiModelProperty(value = "List of valid workflow transition rules.")
  public List<WorkflowTransitionRules> getValidRules() {
    return validRules;
  }

  public void setValidRules(List<WorkflowTransitionRules> validRules) {
    this.validRules = validRules;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WorkflowRulesSearchDetails workflowRulesSearchDetails = (WorkflowRulesSearchDetails) o;
    return Objects.equals(this.workflowEntityId, workflowRulesSearchDetails.workflowEntityId) &&
        Objects.equals(this.invalidRules, workflowRulesSearchDetails.invalidRules) &&
        Objects.equals(this.validRules, workflowRulesSearchDetails.validRules);
  }

  @Override
  public int hashCode() {
    return Objects.hash(workflowEntityId, invalidRules, validRules);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WorkflowRulesSearchDetails {\n");
    
    sb.append("    workflowEntityId: ").append(toIndentedString(workflowEntityId)).append("\n");
    sb.append("    invalidRules: ").append(toIndentedString(invalidRules)).append("\n");
    sb.append("    validRules: ").append(toIndentedString(validRules)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

