/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Details about the mapping from a status to a new status for an issue type.
 */
@ApiModel(description = "Details about the mapping from a status to a new status for an issue type.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-09-03T13:48:26.928+02:00[Europe/Prague]")
public class StatusMapping {
  @JsonProperty("issueTypeId")
  private String issueTypeId;

  @JsonProperty("statusId")
  private String statusId;

  @JsonProperty("newStatusId")
  private String newStatusId;

  public StatusMapping issueTypeId(String issueTypeId) {
    this.issueTypeId = issueTypeId;
    return this;
  }

   /**
   * The ID of the issue type.
   * @return issueTypeId
  **/
  @ApiModelProperty(required = true, value = "The ID of the issue type.")
  public String getIssueTypeId() {
    return issueTypeId;
  }

  public void setIssueTypeId(String issueTypeId) {
    this.issueTypeId = issueTypeId;
  }

  public StatusMapping statusId(String statusId) {
    this.statusId = statusId;
    return this;
  }

   /**
   * The ID of the status.
   * @return statusId
  **/
  @ApiModelProperty(required = true, value = "The ID of the status.")
  public String getStatusId() {
    return statusId;
  }

  public void setStatusId(String statusId) {
    this.statusId = statusId;
  }

  public StatusMapping newStatusId(String newStatusId) {
    this.newStatusId = newStatusId;
    return this;
  }

   /**
   * The ID of the new status.
   * @return newStatusId
  **/
  @ApiModelProperty(required = true, value = "The ID of the new status.")
  public String getNewStatusId() {
    return newStatusId;
  }

  public void setNewStatusId(String newStatusId) {
    this.newStatusId = newStatusId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StatusMapping statusMapping = (StatusMapping) o;
    return Objects.equals(this.issueTypeId, statusMapping.issueTypeId) &&
        Objects.equals(this.statusId, statusMapping.statusId) &&
        Objects.equals(this.newStatusId, statusMapping.newStatusId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(issueTypeId, statusId, newStatusId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StatusMapping {\n");
    
    sb.append("    issueTypeId: ").append(toIndentedString(issueTypeId)).append("\n");
    sb.append("    statusId: ").append(toIndentedString(statusId)).append("\n");
    sb.append("    newStatusId: ").append(toIndentedString(newStatusId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

