/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.everit.atlassian.restclient.jiracloud.v3.model.IdOrKeyBean;
import org.everit.atlassian.restclient.jiracloud.v3.model.JexpIssues;

/**
 * JiraExpressionEvalContextBean
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-09-03T13:48:26.928+02:00[Europe/Prague]")
public class JiraExpressionEvalContextBean {
  @JsonProperty("issue")
  private IdOrKeyBean issue;

  @JsonProperty("issues")
  private JexpIssues issues;

  @JsonProperty("project")
  private IdOrKeyBean project;

  @JsonProperty("sprint")
  private Long sprint;

  @JsonProperty("board")
  private Long board;

  @JsonProperty("serviceDesk")
  private Long serviceDesk;

  @JsonProperty("customerRequest")
  private Long customerRequest;

  public JiraExpressionEvalContextBean issue(IdOrKeyBean issue) {
    this.issue = issue;
    return this;
  }

   /**
   * The issue that is available under the &#x60;issue&#x60; variable when evaluating the expression.
   * @return issue
  **/
  @ApiModelProperty(value = "The issue that is available under the `issue` variable when evaluating the expression.")
  public IdOrKeyBean getIssue() {
    return issue;
  }

  public void setIssue(IdOrKeyBean issue) {
    this.issue = issue;
  }

  public JiraExpressionEvalContextBean issues(JexpIssues issues) {
    this.issues = issues;
    return this;
  }

   /**
   * The collection of issues that is available under the &#x60;issues&#x60; variable when evaluating the expression.
   * @return issues
  **/
  @ApiModelProperty(value = "The collection of issues that is available under the `issues` variable when evaluating the expression.")
  public JexpIssues getIssues() {
    return issues;
  }

  public void setIssues(JexpIssues issues) {
    this.issues = issues;
  }

  public JiraExpressionEvalContextBean project(IdOrKeyBean project) {
    this.project = project;
    return this;
  }

   /**
   * The project that is available under the &#x60;project&#x60; variable when evaluating the expression.
   * @return project
  **/
  @ApiModelProperty(value = "The project that is available under the `project` variable when evaluating the expression.")
  public IdOrKeyBean getProject() {
    return project;
  }

  public void setProject(IdOrKeyBean project) {
    this.project = project;
  }

  public JiraExpressionEvalContextBean sprint(Long sprint) {
    this.sprint = sprint;
    return this;
  }

   /**
   * The ID of the sprint that is available under the &#x60;sprint&#x60; variable when evaluating the expression.
   * @return sprint
  **/
  @ApiModelProperty(value = "The ID of the sprint that is available under the `sprint` variable when evaluating the expression.")
  public Long getSprint() {
    return sprint;
  }

  public void setSprint(Long sprint) {
    this.sprint = sprint;
  }

  public JiraExpressionEvalContextBean board(Long board) {
    this.board = board;
    return this;
  }

   /**
   * The ID of the board that is available under the &#x60;board&#x60; variable when evaluating the expression.
   * @return board
  **/
  @ApiModelProperty(value = "The ID of the board that is available under the `board` variable when evaluating the expression.")
  public Long getBoard() {
    return board;
  }

  public void setBoard(Long board) {
    this.board = board;
  }

  public JiraExpressionEvalContextBean serviceDesk(Long serviceDesk) {
    this.serviceDesk = serviceDesk;
    return this;
  }

   /**
   * The ID of the service desk that is available under the &#x60;serviceDesk&#x60; variable when evaluating the expression.
   * @return serviceDesk
  **/
  @ApiModelProperty(value = "The ID of the service desk that is available under the `serviceDesk` variable when evaluating the expression.")
  public Long getServiceDesk() {
    return serviceDesk;
  }

  public void setServiceDesk(Long serviceDesk) {
    this.serviceDesk = serviceDesk;
  }

  public JiraExpressionEvalContextBean customerRequest(Long customerRequest) {
    this.customerRequest = customerRequest;
    return this;
  }

   /**
   * The ID of the customer request that is available under the &#x60;customerRequest&#x60; variable when evaluating the expression. This is the same as the ID of the underlying Jira issue, but the customer request context variable will have a different type.
   * @return customerRequest
  **/
  @ApiModelProperty(value = "The ID of the customer request that is available under the `customerRequest` variable when evaluating the expression. This is the same as the ID of the underlying Jira issue, but the customer request context variable will have a different type.")
  public Long getCustomerRequest() {
    return customerRequest;
  }

  public void setCustomerRequest(Long customerRequest) {
    this.customerRequest = customerRequest;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JiraExpressionEvalContextBean jiraExpressionEvalContextBean = (JiraExpressionEvalContextBean) o;
    return Objects.equals(this.issue, jiraExpressionEvalContextBean.issue) &&
        Objects.equals(this.issues, jiraExpressionEvalContextBean.issues) &&
        Objects.equals(this.project, jiraExpressionEvalContextBean.project) &&
        Objects.equals(this.sprint, jiraExpressionEvalContextBean.sprint) &&
        Objects.equals(this.board, jiraExpressionEvalContextBean.board) &&
        Objects.equals(this.serviceDesk, jiraExpressionEvalContextBean.serviceDesk) &&
        Objects.equals(this.customerRequest, jiraExpressionEvalContextBean.customerRequest);
  }

  @Override
  public int hashCode() {
    return Objects.hash(issue, issues, project, sprint, board, serviceDesk, customerRequest);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JiraExpressionEvalContextBean {\n");
    
    sb.append("    issue: ").append(toIndentedString(issue)).append("\n");
    sb.append("    issues: ").append(toIndentedString(issues)).append("\n");
    sb.append("    project: ").append(toIndentedString(project)).append("\n");
    sb.append("    sprint: ").append(toIndentedString(sprint)).append("\n");
    sb.append("    board: ").append(toIndentedString(board)).append("\n");
    sb.append("    serviceDesk: ").append(toIndentedString(serviceDesk)).append("\n");
    sb.append("    customerRequest: ").append(toIndentedString(customerRequest)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

