/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Details about the mapping between an issue type and a workflow.
 */
@ApiModel(description = "Details about the mapping between an issue type and a workflow.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-09-03T13:48:26.928+02:00[Europe/Prague]")
public class IssueTypeWorkflowMapping {
  @JsonProperty("issueType")
  private String issueType;

  @JsonProperty("workflow")
  private String workflow;

  @JsonProperty("updateDraftIfNeeded")
  private Boolean updateDraftIfNeeded;

  public IssueTypeWorkflowMapping issueType(String issueType) {
    this.issueType = issueType;
    return this;
  }

   /**
   * The ID of the issue type. Not required if updating the issue type-workflow mapping.
   * @return issueType
  **/
  @ApiModelProperty(value = "The ID of the issue type. Not required if updating the issue type-workflow mapping.")
  public String getIssueType() {
    return issueType;
  }

  public void setIssueType(String issueType) {
    this.issueType = issueType;
  }

  public IssueTypeWorkflowMapping workflow(String workflow) {
    this.workflow = workflow;
    return this;
  }

   /**
   * The name of the workflow.
   * @return workflow
  **/
  @ApiModelProperty(value = "The name of the workflow.")
  public String getWorkflow() {
    return workflow;
  }

  public void setWorkflow(String workflow) {
    this.workflow = workflow;
  }

  public IssueTypeWorkflowMapping updateDraftIfNeeded(Boolean updateDraftIfNeeded) {
    this.updateDraftIfNeeded = updateDraftIfNeeded;
    return this;
  }

   /**
   * Set to true to create or update the draft of a workflow scheme and update the mapping in the draft, when the workflow scheme cannot be edited. Defaults to &#x60;false&#x60;. Only applicable when updating the workflow-issue types mapping.
   * @return updateDraftIfNeeded
  **/
  @ApiModelProperty(value = "Set to true to create or update the draft of a workflow scheme and update the mapping in the draft, when the workflow scheme cannot be edited. Defaults to `false`. Only applicable when updating the workflow-issue types mapping.")
  public Boolean getUpdateDraftIfNeeded() {
    return updateDraftIfNeeded;
  }

  public void setUpdateDraftIfNeeded(Boolean updateDraftIfNeeded) {
    this.updateDraftIfNeeded = updateDraftIfNeeded;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IssueTypeWorkflowMapping issueTypeWorkflowMapping = (IssueTypeWorkflowMapping) o;
    return Objects.equals(this.issueType, issueTypeWorkflowMapping.issueType) &&
        Objects.equals(this.workflow, issueTypeWorkflowMapping.workflow) &&
        Objects.equals(this.updateDraftIfNeeded, issueTypeWorkflowMapping.updateDraftIfNeeded);
  }

  @Override
  public int hashCode() {
    return Objects.hash(issueType, workflow, updateDraftIfNeeded);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IssueTypeWorkflowMapping {\n");
    
    sb.append("    issueType: ").append(toIndentedString(issueType)).append("\n");
    sb.append("    workflow: ").append(toIndentedString(workflow)).append("\n");
    sb.append("    updateDraftIfNeeded: ").append(toIndentedString(updateDraftIfNeeded)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

