/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Details of the contextual configuration for a custom field.
 */
@ApiModel(description = "Details of the contextual configuration for a custom field.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-09-03T13:48:26.928+02:00[Europe/Prague]")
public class ContextualConfiguration {
  @JsonProperty("contextId")
  private Long contextId;

  @JsonProperty("configuration")
  private Object _configuration = null;

  @JsonProperty("schema")
  private Object schema = null;

  public ContextualConfiguration contextId(Long contextId) {
    this.contextId = contextId;
    return this;
  }

   /**
   * The ID of the context the configuration is associated with.
   * @return contextId
  **/
  @ApiModelProperty(required = true, value = "The ID of the context the configuration is associated with.")
  public Long getContextId() {
    return contextId;
  }

  public void setContextId(Long contextId) {
    this.contextId = contextId;
  }

  public ContextualConfiguration _configuration(Object _configuration) {
    this._configuration = _configuration;
    return this;
  }

   /**
   * The configuration associated with the context.
   * @return _configuration
  **/
  @ApiModelProperty(value = "The configuration associated with the context.")
  public Object getConfiguration() {
    return _configuration;
  }

  public void setConfiguration(Object _configuration) {
    this._configuration = _configuration;
  }

  public ContextualConfiguration schema(Object schema) {
    this.schema = schema;
    return this;
  }

   /**
   * The schema associated with the context.
   * @return schema
  **/
  @ApiModelProperty(value = "The schema associated with the context.")
  public Object getSchema() {
    return schema;
  }

  public void setSchema(Object schema) {
    this.schema = schema;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ContextualConfiguration contextualConfiguration = (ContextualConfiguration) o;
    return Objects.equals(this.contextId, contextualConfiguration.contextId) &&
        Objects.equals(this._configuration, contextualConfiguration._configuration) &&
        Objects.equals(this.schema, contextualConfiguration.schema);
  }

  @Override
  public int hashCode() {
    return Objects.hash(contextId, _configuration, schema);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ContextualConfiguration {\n");
    
    sb.append("    contextId: ").append(toIndentedString(contextId)).append("\n");
    sb.append("    _configuration: ").append(toIndentedString(_configuration)).append("\n");
    sb.append("    schema: ").append(toIndentedString(schema)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

