/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.everit.atlassian.restclient.jiracloud.v2.model.Scope;
import org.everit.atlassian.restclient.jiracloud.v2.model.ScreenableTab;

/**
 * A screen with tab details.
 */
@ApiModel(description = "A screen with tab details.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-09-03T13:48:17.349+02:00[Europe/Prague]")
public class ScreenWithTab {
  @JsonProperty("id")
  private Long id;

  @JsonProperty("name")
  private String name;

  @JsonProperty("description")
  private String description;

  @JsonProperty("scope")
  private Scope scope;

  @JsonProperty("tab")
  private ScreenableTab tab;

   /**
   * The ID of the screen.
   * @return id
  **/
  @ApiModelProperty(value = "The ID of the screen.")
  public Long getId() {
    return id;
  }

   /**
   * The name of the screen.
   * @return name
  **/
  @ApiModelProperty(value = "The name of the screen.")
  public String getName() {
    return name;
  }

   /**
   * The description of the screen.
   * @return description
  **/
  @ApiModelProperty(value = "The description of the screen.")
  public String getDescription() {
    return description;
  }

  public ScreenWithTab scope(Scope scope) {
    this.scope = scope;
    return this;
  }

   /**
   * The scope of the screen.
   * @return scope
  **/
  @ApiModelProperty(value = "The scope of the screen.")
  public Scope getScope() {
    return scope;
  }

  public void setScope(Scope scope) {
    this.scope = scope;
  }

  public ScreenWithTab tab(ScreenableTab tab) {
    this.tab = tab;
    return this;
  }

   /**
   * The tab for the screen.
   * @return tab
  **/
  @ApiModelProperty(value = "The tab for the screen.")
  public ScreenableTab getTab() {
    return tab;
  }

  public void setTab(ScreenableTab tab) {
    this.tab = tab;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ScreenWithTab screenWithTab = (ScreenWithTab) o;
    return Objects.equals(this.id, screenWithTab.id) &&
        Objects.equals(this.name, screenWithTab.name) &&
        Objects.equals(this.description, screenWithTab.description) &&
        Objects.equals(this.scope, screenWithTab.scope) &&
        Objects.equals(this.tab, screenWithTab.tab);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, description, scope, tab);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ScreenWithTab {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
    sb.append("    tab: ").append(toIndentedString(tab)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

