/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.everit.atlassian.restclient.jiracloud.v2.model.JiraExpressionComplexity;
import org.everit.atlassian.restclient.jiracloud.v2.model.JiraExpressionValidationError;

/**
 * Details about the analysed Jira expression.
 */
@ApiModel(description = "Details about the analysed Jira expression.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-09-03T13:48:17.349+02:00[Europe/Prague]")
public class JiraExpressionAnalysis {
  @JsonProperty("expression")
  private String expression;

  @JsonProperty("errors")
  private List<JiraExpressionValidationError> errors = new ArrayList<>();

  @JsonProperty("valid")
  private Boolean valid;

  @JsonProperty("type")
  private String type;

  @JsonProperty("complexity")
  private JiraExpressionComplexity complexity;

  public JiraExpressionAnalysis expression(String expression) {
    this.expression = expression;
    return this;
  }

   /**
   * The analysed expression.
   * @return expression
  **/
  @ApiModelProperty(required = true, value = "The analysed expression.")
  public String getExpression() {
    return expression;
  }

  public void setExpression(String expression) {
    this.expression = expression;
  }

  public JiraExpressionAnalysis errors(List<JiraExpressionValidationError> errors) {
    this.errors = errors;
    return this;
  }

  public JiraExpressionAnalysis addErrorsItem(JiraExpressionValidationError errorsItem) {
    if (this.errors == null) {
      this.errors = new ArrayList<>();
    }
    this.errors.add(errorsItem);
    return this;
  }

   /**
   * A list of validation errors. Not included if the expression is valid.
   * @return errors
  **/
  @ApiModelProperty(value = "A list of validation errors. Not included if the expression is valid.")
  public List<JiraExpressionValidationError> getErrors() {
    return errors;
  }

  public void setErrors(List<JiraExpressionValidationError> errors) {
    this.errors = errors;
  }

  public JiraExpressionAnalysis valid(Boolean valid) {
    this.valid = valid;
    return this;
  }

   /**
   * Whether the expression is valid and the interpreter will evaluate it. Note that the expression may fail at runtime (for example, if it executes too many expensive operations).
   * @return valid
  **/
  @ApiModelProperty(required = true, value = "Whether the expression is valid and the interpreter will evaluate it. Note that the expression may fail at runtime (for example, if it executes too many expensive operations).")
  public Boolean getValid() {
    return valid;
  }

  public void setValid(Boolean valid) {
    this.valid = valid;
  }

  public JiraExpressionAnalysis type(String type) {
    this.type = type;
    return this;
  }

   /**
   * EXPERIMENTAL. The inferred type of the expression.
   * @return type
  **/
  @ApiModelProperty(value = "EXPERIMENTAL. The inferred type of the expression.")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public JiraExpressionAnalysis complexity(JiraExpressionComplexity complexity) {
    this.complexity = complexity;
    return this;
  }

   /**
   * Get complexity
   * @return complexity
  **/
  @ApiModelProperty(value = "")
  public JiraExpressionComplexity getComplexity() {
    return complexity;
  }

  public void setComplexity(JiraExpressionComplexity complexity) {
    this.complexity = complexity;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JiraExpressionAnalysis jiraExpressionAnalysis = (JiraExpressionAnalysis) o;
    return Objects.equals(this.expression, jiraExpressionAnalysis.expression) &&
        Objects.equals(this.errors, jiraExpressionAnalysis.errors) &&
        Objects.equals(this.valid, jiraExpressionAnalysis.valid) &&
        Objects.equals(this.type, jiraExpressionAnalysis.type) &&
        Objects.equals(this.complexity, jiraExpressionAnalysis.complexity);
  }

  @Override
  public int hashCode() {
    return Objects.hash(expression, errors, valid, type, complexity);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JiraExpressionAnalysis {\n");
    
    sb.append("    expression: ").append(toIndentedString(expression)).append("\n");
    sb.append("    errors: ").append(toIndentedString(errors)).append("\n");
    sb.append("    valid: ").append(toIndentedString(valid)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    complexity: ").append(toIndentedString(complexity)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

