/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * HierarchyLevel
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-09-03T13:48:17.349+02:00[Europe/Prague]")
public class HierarchyLevel {
  @JsonProperty("id")
  private Long id;

  @JsonProperty("name")
  private String name;

  @JsonProperty("aboveLevelId")
  private Long aboveLevelId;

  @JsonProperty("belowLevelId")
  private Long belowLevelId;

  @JsonProperty("projectConfigurationId")
  private Long projectConfigurationId;

  @JsonProperty("level")
  private Integer level;

  @JsonProperty("issueTypeIds")
  private List<Long> issueTypeIds = new ArrayList<>();

  @JsonProperty("externalUuid")
  private UUID externalUuid;

  /**
   * Gets or Sets globalHierarchyLevel
   */
  public enum GlobalHierarchyLevelEnum {
    SUBTASK("SUBTASK"),
    
    BASE("BASE"),
    
    EPIC("EPIC");

    private String value;

    GlobalHierarchyLevelEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static GlobalHierarchyLevelEnum fromValue(String value) {
      for (GlobalHierarchyLevelEnum b : GlobalHierarchyLevelEnum.values()) {
        if (b.value.equalsIgnoreCase(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("globalHierarchyLevel")
  private GlobalHierarchyLevelEnum globalHierarchyLevel;

  public HierarchyLevel id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * The ID of the hierarchy level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).
   * @return id
  **/
  @ApiModelProperty(value = "The ID of the hierarchy level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public HierarchyLevel name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of this hierarchy level.
   * @return name
  **/
  @ApiModelProperty(value = "The name of this hierarchy level.")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public HierarchyLevel aboveLevelId(Long aboveLevelId) {
    this.aboveLevelId = aboveLevelId;
    return this;
  }

   /**
   * The ID of the level above this one in the hierarchy. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).
   * @return aboveLevelId
  **/
  @ApiModelProperty(value = "The ID of the level above this one in the hierarchy. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).")
  public Long getAboveLevelId() {
    return aboveLevelId;
  }

  public void setAboveLevelId(Long aboveLevelId) {
    this.aboveLevelId = aboveLevelId;
  }

  public HierarchyLevel belowLevelId(Long belowLevelId) {
    this.belowLevelId = belowLevelId;
    return this;
  }

   /**
   * The ID of the level below this one in the hierarchy. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).
   * @return belowLevelId
  **/
  @ApiModelProperty(value = "The ID of the level below this one in the hierarchy. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).")
  public Long getBelowLevelId() {
    return belowLevelId;
  }

  public void setBelowLevelId(Long belowLevelId) {
    this.belowLevelId = belowLevelId;
  }

  public HierarchyLevel projectConfigurationId(Long projectConfigurationId) {
    this.projectConfigurationId = projectConfigurationId;
    return this;
  }

   /**
   * The ID of the project configuration. This property is deprecated, see [Change oticen: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).
   * @return projectConfigurationId
  **/
  @ApiModelProperty(value = "The ID of the project configuration. This property is deprecated, see [Change oticen: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).")
  public Long getProjectConfigurationId() {
    return projectConfigurationId;
  }

  public void setProjectConfigurationId(Long projectConfigurationId) {
    this.projectConfigurationId = projectConfigurationId;
  }

  public HierarchyLevel level(Integer level) {
    this.level = level;
    return this;
  }

   /**
   * The level of this item in the hierarchy.
   * @return level
  **/
  @ApiModelProperty(value = "The level of this item in the hierarchy.")
  public Integer getLevel() {
    return level;
  }

  public void setLevel(Integer level) {
    this.level = level;
  }

  public HierarchyLevel issueTypeIds(List<Long> issueTypeIds) {
    this.issueTypeIds = issueTypeIds;
    return this;
  }

  public HierarchyLevel addIssueTypeIdsItem(Long issueTypeIdsItem) {
    if (this.issueTypeIds == null) {
      this.issueTypeIds = new ArrayList<>();
    }
    this.issueTypeIds.add(issueTypeIdsItem);
    return this;
  }

   /**
   * The issue types available in this hierarchy level.
   * @return issueTypeIds
  **/
  @ApiModelProperty(value = "The issue types available in this hierarchy level.")
  public List<Long> getIssueTypeIds() {
    return issueTypeIds;
  }

  public void setIssueTypeIds(List<Long> issueTypeIds) {
    this.issueTypeIds = issueTypeIds;
  }

  public HierarchyLevel externalUuid(UUID externalUuid) {
    this.externalUuid = externalUuid;
    return this;
  }

   /**
   * The external UUID of the hierarchy level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).
   * @return externalUuid
  **/
  @ApiModelProperty(value = "The external UUID of the hierarchy level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).")
  public UUID getExternalUuid() {
    return externalUuid;
  }

  public void setExternalUuid(UUID externalUuid) {
    this.externalUuid = externalUuid;
  }

  public HierarchyLevel globalHierarchyLevel(GlobalHierarchyLevelEnum globalHierarchyLevel) {
    this.globalHierarchyLevel = globalHierarchyLevel;
    return this;
  }

   /**
   * Get globalHierarchyLevel
   * @return globalHierarchyLevel
  **/
  @ApiModelProperty(value = "")
  public GlobalHierarchyLevelEnum getGlobalHierarchyLevel() {
    return globalHierarchyLevel;
  }

  public void setGlobalHierarchyLevel(GlobalHierarchyLevelEnum globalHierarchyLevel) {
    this.globalHierarchyLevel = globalHierarchyLevel;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HierarchyLevel hierarchyLevel = (HierarchyLevel) o;
    return Objects.equals(this.id, hierarchyLevel.id) &&
        Objects.equals(this.name, hierarchyLevel.name) &&
        Objects.equals(this.aboveLevelId, hierarchyLevel.aboveLevelId) &&
        Objects.equals(this.belowLevelId, hierarchyLevel.belowLevelId) &&
        Objects.equals(this.projectConfigurationId, hierarchyLevel.projectConfigurationId) &&
        Objects.equals(this.level, hierarchyLevel.level) &&
        Objects.equals(this.issueTypeIds, hierarchyLevel.issueTypeIds) &&
        Objects.equals(this.externalUuid, hierarchyLevel.externalUuid) &&
        Objects.equals(this.globalHierarchyLevel, hierarchyLevel.globalHierarchyLevel);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, aboveLevelId, belowLevelId, projectConfigurationId, level, issueTypeIds, externalUuid, globalHierarchyLevel);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HierarchyLevel {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    aboveLevelId: ").append(toIndentedString(aboveLevelId)).append("\n");
    sb.append("    belowLevelId: ").append(toIndentedString(belowLevelId)).append("\n");
    sb.append("    projectConfigurationId: ").append(toIndentedString(projectConfigurationId)).append("\n");
    sb.append("    level: ").append(toIndentedString(level)).append("\n");
    sb.append("    issueTypeIds: ").append(toIndentedString(issueTypeIds)).append("\n");
    sb.append("    externalUuid: ").append(toIndentedString(externalUuid)).append("\n");
    sb.append("    globalHierarchyLevel: ").append(toIndentedString(globalHierarchyLevel)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

