/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
 * EntityPropertyDetails
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-09-03T13:48:17.349+02:00[Europe/Prague]")
public class EntityPropertyDetails {
  @JsonProperty("entityId")
  private BigDecimal entityId;

  @JsonProperty("key")
  private String key;

  @JsonProperty("value")
  private String value;

  public EntityPropertyDetails entityId(BigDecimal entityId) {
    this.entityId = entityId;
    return this;
  }

   /**
   * The entity property ID.
   * @return entityId
  **/
  @ApiModelProperty(example = "123", required = true, value = "The entity property ID.")
  public BigDecimal getEntityId() {
    return entityId;
  }

  public void setEntityId(BigDecimal entityId) {
    this.entityId = entityId;
  }

  public EntityPropertyDetails key(String key) {
    this.key = key;
    return this;
  }

   /**
   * The entity property key.
   * @return key
  **/
  @ApiModelProperty(example = "mykey", required = true, value = "The entity property key.")
  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public EntityPropertyDetails value(String value) {
    this.value = value;
    return this;
  }

   /**
   * The new value of the entity property.
   * @return value
  **/
  @ApiModelProperty(example = "newValue", required = true, value = "The new value of the entity property.")
  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EntityPropertyDetails entityPropertyDetails = (EntityPropertyDetails) o;
    return Objects.equals(this.entityId, entityPropertyDetails.entityId) &&
        Objects.equals(this.key, entityPropertyDetails.key) &&
        Objects.equals(this.value, entityPropertyDetails.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(entityId, key, value);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EntityPropertyDetails {\n");
    
    sb.append("    entityId: ").append(toIndentedString(entityId)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

