/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
 * A list of custom field details.
 */
@ApiModel(description = "A list of custom field details.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-09-03T13:48:17.349+02:00[Europe/Prague]")
public class ConnectCustomFieldValue {
  /**
   * The type of custom field.
   */
  public enum TypeEnum {
    STRINGISSUEFIELD("StringIssueField"),
    
    NUMBERISSUEFIELD("NumberIssueField"),
    
    RICHTEXTISSUEFIELD("RichTextIssueField"),
    
    SINGLESELECTISSUEFIELD("SingleSelectIssueField"),
    
    MULTISELECTISSUEFIELD("MultiSelectIssueField"),
    
    TEXTISSUEFIELD("TextIssueField");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equalsIgnoreCase(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("_type")
  private TypeEnum type;

  @JsonProperty("issueID")
  private Integer issueID;

  @JsonProperty("fieldID")
  private Integer fieldID;

  @JsonProperty("string")
  private String string;

  @JsonProperty("number")
  private BigDecimal number;

  @JsonProperty("richText")
  private String richText;

  @JsonProperty("optionID")
  private String optionID;

  @JsonProperty("text")
  private String text;

  public ConnectCustomFieldValue type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * The type of custom field.
   * @return type
  **/
  @ApiModelProperty(required = true, value = "The type of custom field.")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public ConnectCustomFieldValue issueID(Integer issueID) {
    this.issueID = issueID;
    return this;
  }

   /**
   * The issue ID.
   * @return issueID
  **/
  @ApiModelProperty(required = true, value = "The issue ID.")
  public Integer getIssueID() {
    return issueID;
  }

  public void setIssueID(Integer issueID) {
    this.issueID = issueID;
  }

  public ConnectCustomFieldValue fieldID(Integer fieldID) {
    this.fieldID = fieldID;
    return this;
  }

   /**
   * The custom field ID.
   * @return fieldID
  **/
  @ApiModelProperty(required = true, value = "The custom field ID.")
  public Integer getFieldID() {
    return fieldID;
  }

  public void setFieldID(Integer fieldID) {
    this.fieldID = fieldID;
  }

  public ConnectCustomFieldValue string(String string) {
    this.string = string;
    return this;
  }

   /**
   * The value of string type custom field when &#x60;_type&#x60; is &#x60;StringIssueField&#x60;.
   * @return string
  **/
  @ApiModelProperty(value = "The value of string type custom field when `_type` is `StringIssueField`.")
  public String getString() {
    return string;
  }

  public void setString(String string) {
    this.string = string;
  }

  public ConnectCustomFieldValue number(BigDecimal number) {
    this.number = number;
    return this;
  }

   /**
   * The value of number type custom field when &#x60;_type&#x60; is &#x60;NumberIssueField&#x60;.
   * @return number
  **/
  @ApiModelProperty(value = "The value of number type custom field when `_type` is `NumberIssueField`.")
  public BigDecimal getNumber() {
    return number;
  }

  public void setNumber(BigDecimal number) {
    this.number = number;
  }

  public ConnectCustomFieldValue richText(String richText) {
    this.richText = richText;
    return this;
  }

   /**
   * The value of richText type custom field when &#x60;_type&#x60; is &#x60;RichTextIssueField&#x60;.
   * @return richText
  **/
  @ApiModelProperty(value = "The value of richText type custom field when `_type` is `RichTextIssueField`.")
  public String getRichText() {
    return richText;
  }

  public void setRichText(String richText) {
    this.richText = richText;
  }

  public ConnectCustomFieldValue optionID(String optionID) {
    this.optionID = optionID;
    return this;
  }

   /**
   * The value of single select and multiselect custom field type when &#x60;_type&#x60; is &#x60;SingleSelectIssueField&#x60; or &#x60;MultiSelectIssueField&#x60;.
   * @return optionID
  **/
  @ApiModelProperty(value = "The value of single select and multiselect custom field type when `_type` is `SingleSelectIssueField` or `MultiSelectIssueField`.")
  public String getOptionID() {
    return optionID;
  }

  public void setOptionID(String optionID) {
    this.optionID = optionID;
  }

  public ConnectCustomFieldValue text(String text) {
    this.text = text;
    return this;
  }

   /**
   * The value of of text custom field type when &#x60;_type&#x60; is &#x60;TextIssueField&#x60;.
   * @return text
  **/
  @ApiModelProperty(value = "The value of of text custom field type when `_type` is `TextIssueField`.")
  public String getText() {
    return text;
  }

  public void setText(String text) {
    this.text = text;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ConnectCustomFieldValue connectCustomFieldValue = (ConnectCustomFieldValue) o;
    return Objects.equals(this.type, connectCustomFieldValue.type) &&
        Objects.equals(this.issueID, connectCustomFieldValue.issueID) &&
        Objects.equals(this.fieldID, connectCustomFieldValue.fieldID) &&
        Objects.equals(this.string, connectCustomFieldValue.string) &&
        Objects.equals(this.number, connectCustomFieldValue.number) &&
        Objects.equals(this.richText, connectCustomFieldValue.richText) &&
        Objects.equals(this.optionID, connectCustomFieldValue.optionID) &&
        Objects.equals(this.text, connectCustomFieldValue.text);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, issueID, fieldID, string, number, richText, optionID, text);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ConnectCustomFieldValue {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    issueID: ").append(toIndentedString(issueID)).append("\n");
    sb.append("    fieldID: ").append(toIndentedString(fieldID)).append("\n");
    sb.append("    string: ").append(toIndentedString(string)).append("\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    richText: ").append(toIndentedString(richText)).append("\n");
    sb.append("    optionID: ").append(toIndentedString(optionID)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

