/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.PublishedWorkflowId;
import org.everit.atlassian.restclient.jiracloud.v3.model.Transition;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowStatus;

@ApiModel(description="Details about a workflow.")
public class Workflow {
    @JsonProperty(value="id")
    private PublishedWorkflowId id;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="transitions")
    private List<Transition> transitions = new ArrayList<Transition>();
    @JsonProperty(value="statuses")
    private List<WorkflowStatus> statuses = new ArrayList<WorkflowStatus>();

    public Workflow id(PublishedWorkflowId id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="")
    public PublishedWorkflowId getId() {
        return this.id;
    }

    public void setId(PublishedWorkflowId id) {
        this.id = id;
    }

    public Workflow description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="The description of the workflow.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Workflow transitions(List<Transition> transitions) {
        this.transitions = transitions;
        return this;
    }

    public Workflow addTransitionsItem(Transition transitionsItem) {
        if (this.transitions == null) {
            this.transitions = new ArrayList<Transition>();
        }
        this.transitions.add(transitionsItem);
        return this;
    }

    @ApiModelProperty(value="The transitions of the workflow.")
    public List<Transition> getTransitions() {
        return this.transitions;
    }

    public void setTransitions(List<Transition> transitions) {
        this.transitions = transitions;
    }

    public Workflow statuses(List<WorkflowStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    public Workflow addStatusesItem(WorkflowStatus statusesItem) {
        if (this.statuses == null) {
            this.statuses = new ArrayList<WorkflowStatus>();
        }
        this.statuses.add(statusesItem);
        return this;
    }

    @ApiModelProperty(value="The statuses of the workflow.")
    public List<WorkflowStatus> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<WorkflowStatus> statuses) {
        this.statuses = statuses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Workflow workflow = (Workflow)o;
        return Objects.equals(this.id, workflow.id) && Objects.equals(this.description, workflow.description) && Objects.equals(this.transitions, workflow.transitions) && Objects.equals(this.statuses, workflow.statuses);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.description, this.transitions, this.statuses);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Workflow {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    transitions: ").append(this.toIndentedString(this.transitions)).append("\n");
        sb.append("    statuses: ").append(this.toIndentedString(this.statuses)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

