/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.VersionUsageInCustomField;

@ApiModel(description="Various counts of issues within a version.")
public class VersionIssueCounts {
    @JsonProperty(value="self")
    private URI self;
    @JsonProperty(value="issuesFixedCount")
    private Long issuesFixedCount;
    @JsonProperty(value="issuesAffectedCount")
    private Long issuesAffectedCount;
    @JsonProperty(value="issueCountWithCustomFieldsShowingVersion")
    private Long issueCountWithCustomFieldsShowingVersion;
    @JsonProperty(value="customFieldUsage")
    private List<VersionUsageInCustomField> customFieldUsage = new ArrayList<VersionUsageInCustomField>();

    @ApiModelProperty(value="The URL of these count details.")
    public URI getSelf() {
        return this.self;
    }

    @ApiModelProperty(value="Count of issues where the `fixVersion` is set to the version.")
    public Long getIssuesFixedCount() {
        return this.issuesFixedCount;
    }

    @ApiModelProperty(value="Count of issues where the `affectedVersion` is set to the version.")
    public Long getIssuesAffectedCount() {
        return this.issuesAffectedCount;
    }

    @ApiModelProperty(value="Count of issues where a version custom field is set to the version.")
    public Long getIssueCountWithCustomFieldsShowingVersion() {
        return this.issueCountWithCustomFieldsShowingVersion;
    }

    @ApiModelProperty(value="List of custom fields using the version.")
    public List<VersionUsageInCustomField> getCustomFieldUsage() {
        return this.customFieldUsage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionIssueCounts versionIssueCounts = (VersionIssueCounts)o;
        return Objects.equals(this.self, versionIssueCounts.self) && Objects.equals(this.issuesFixedCount, versionIssueCounts.issuesFixedCount) && Objects.equals(this.issuesAffectedCount, versionIssueCounts.issuesAffectedCount) && Objects.equals(this.issueCountWithCustomFieldsShowingVersion, versionIssueCounts.issueCountWithCustomFieldsShowingVersion) && Objects.equals(this.customFieldUsage, versionIssueCounts.customFieldUsage);
    }

    public int hashCode() {
        return Objects.hash(this.self, this.issuesFixedCount, this.issuesAffectedCount, this.issueCountWithCustomFieldsShowingVersion, this.customFieldUsage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VersionIssueCounts {\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    issuesFixedCount: ").append(this.toIndentedString(this.issuesFixedCount)).append("\n");
        sb.append("    issuesAffectedCount: ").append(this.toIndentedString(this.issuesAffectedCount)).append("\n");
        sb.append("    issueCountWithCustomFieldsShowingVersion: ").append(this.toIndentedString(this.issueCountWithCustomFieldsShowingVersion)).append("\n");
        sb.append("    customFieldUsage: ").append(this.toIndentedString(this.customFieldUsage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

