/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="ID of a registered webhook or error messages explaining why a webhook wasn't registered.")
public class RegisteredWebhook {
    @JsonProperty(value="createdWebhookId")
    private Long createdWebhookId;
    @JsonProperty(value="errors")
    private List<String> errors = new ArrayList<String>();

    public RegisteredWebhook createdWebhookId(Long createdWebhookId) {
        this.createdWebhookId = createdWebhookId;
        return this;
    }

    @ApiModelProperty(value="The ID of the webhook. Returned if the webhook is created.")
    public Long getCreatedWebhookId() {
        return this.createdWebhookId;
    }

    public void setCreatedWebhookId(Long createdWebhookId) {
        this.createdWebhookId = createdWebhookId;
    }

    public RegisteredWebhook errors(List<String> errors) {
        this.errors = errors;
        return this;
    }

    public RegisteredWebhook addErrorsItem(String errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="Error messages specifying why the webhook creation failed.")
    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisteredWebhook registeredWebhook = (RegisteredWebhook)o;
        return Objects.equals(this.createdWebhookId, registeredWebhook.createdWebhookId) && Objects.equals(this.errors, registeredWebhook.errors);
    }

    public int hashCode() {
        return Objects.hash(this.createdWebhookId, this.errors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RegisteredWebhook {\n");
        sb.append("    createdWebhookId: ").append(this.toIndentedString(this.createdWebhookId)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

