/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueTypeInfo;

@ApiModel(description="Details of an issue type hierarchy level.")
public class ProjectIssueTypesHierarchyLevel {
    @JsonProperty(value="entityId")
    private UUID entityId;
    @JsonProperty(value="level")
    private Integer level;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="issueTypes")
    private List<IssueTypeInfo> issueTypes = new ArrayList<IssueTypeInfo>();

    @ApiModelProperty(value="The ID of the issue type hierarchy level.")
    public UUID getEntityId() {
        return this.entityId;
    }

    @ApiModelProperty(value="The level of the issue type hierarchy level.")
    public Integer getLevel() {
        return this.level;
    }

    @ApiModelProperty(value="The name of the issue type hierarchy level.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The list of issue types in the hierarchy level.")
    public List<IssueTypeInfo> getIssueTypes() {
        return this.issueTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectIssueTypesHierarchyLevel projectIssueTypesHierarchyLevel = (ProjectIssueTypesHierarchyLevel)o;
        return Objects.equals(this.entityId, projectIssueTypesHierarchyLevel.entityId) && Objects.equals(this.level, projectIssueTypesHierarchyLevel.level) && Objects.equals(this.name, projectIssueTypesHierarchyLevel.name) && Objects.equals(this.issueTypes, projectIssueTypesHierarchyLevel.issueTypes);
    }

    public int hashCode() {
        return Objects.hash(this.entityId, this.level, this.name, this.issueTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectIssueTypesHierarchyLevel {\n");
        sb.append("    entityId: ").append(this.toIndentedString(this.entityId)).append("\n");
        sb.append("    level: ").append(this.toIndentedString(this.level)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    issueTypes: ").append(this.toIndentedString(this.issueTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

