/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Details about the complexity of the analysed Jira expression.")
public class JiraExpressionComplexity {
    @JsonProperty(value="expensiveOperations")
    private String expensiveOperations;
    @JsonProperty(value="variables")
    private Map<String, String> variables = new HashMap<String, String>();

    public JiraExpressionComplexity expensiveOperations(String expensiveOperations) {
        this.expensiveOperations = expensiveOperations;
        return this;
    }

    @ApiModelProperty(required=true, value="Information that can be used to determine how many [expensive operations](https://developer.atlassian.com/cloud/jira/platform/jira-expressions/#expensive-operations) the evaluation of the expression will perform. This information may be a formula or number. For example:   *  `issues.map(i => i.comments)` performs as many expensive operations as there are issues on the issues list. So this parameter returns `N`, where `N` is the size of issue list.  *  `new Issue(10010).comments` gets comments for one issue, so its complexity is `2` (`1` to retrieve issue 10010 from the database plus `1` to get its comments).")
    public String getExpensiveOperations() {
        return this.expensiveOperations;
    }

    public void setExpensiveOperations(String expensiveOperations) {
        this.expensiveOperations = expensiveOperations;
    }

    public JiraExpressionComplexity variables(Map<String, String> variables) {
        this.variables = variables;
        return this;
    }

    public JiraExpressionComplexity putVariablesItem(String key, String variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, String>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @ApiModelProperty(value="Variables used in the formula, mapped to the parts of the expression they refer to.")
    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JiraExpressionComplexity jiraExpressionComplexity = (JiraExpressionComplexity)o;
        return Objects.equals(this.expensiveOperations, jiraExpressionComplexity.expensiveOperations) && Objects.equals(this.variables, jiraExpressionComplexity.variables);
    }

    public int hashCode() {
        return Objects.hash(this.expensiveOperations, this.variables);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JiraExpressionComplexity {\n");
        sb.append("    expensiveOperations: ").append(this.toIndentedString(this.expensiveOperations)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

