/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueTypeScreenSchemeMapping;

@ApiModel(description="The details of an issue type screen scheme.")
public class IssueTypeScreenSchemeDetails {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="issueTypeMappings")
    private List<IssueTypeScreenSchemeMapping> issueTypeMappings = new ArrayList<IssueTypeScreenSchemeMapping>();

    public IssueTypeScreenSchemeDetails name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the issue type screen scheme. The name must be unique. The maximum length is 255 characters.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IssueTypeScreenSchemeDetails description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the issue type screen scheme. The maximum length is 255 characters.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public IssueTypeScreenSchemeDetails issueTypeMappings(List<IssueTypeScreenSchemeMapping> issueTypeMappings) {
        this.issueTypeMappings = issueTypeMappings;
        return this;
    }

    public IssueTypeScreenSchemeDetails addIssueTypeMappingsItem(IssueTypeScreenSchemeMapping issueTypeMappingsItem) {
        this.issueTypeMappings.add(issueTypeMappingsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The IDs of the screen schemes for the issue type IDs and *default*. A *default* entry is required to create an issue type screen scheme, it defines the mapping for all issue types without a screen scheme.")
    public List<IssueTypeScreenSchemeMapping> getIssueTypeMappings() {
        return this.issueTypeMappings;
    }

    public void setIssueTypeMappings(List<IssueTypeScreenSchemeMapping> issueTypeMappings) {
        this.issueTypeMappings = issueTypeMappings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueTypeScreenSchemeDetails issueTypeScreenSchemeDetails = (IssueTypeScreenSchemeDetails)o;
        return Objects.equals(this.name, issueTypeScreenSchemeDetails.name) && Objects.equals(this.description, issueTypeScreenSchemeDetails.description) && Objects.equals(this.issueTypeMappings, issueTypeScreenSchemeDetails.issueTypeMappings);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.issueTypeMappings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueTypeScreenSchemeDetails {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    issueTypeMappings: ").append(this.toIndentedString(this.issueTypeMappings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

