/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueFieldOptionConfiguration;

@ApiModel(description="Details of the options for a select list issue field.")
public class IssueFieldOption {
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="value")
    private String value;
    @JsonProperty(value="properties")
    private Map<String, Object> properties = new HashMap<String, Object>();
    @JsonProperty(value="config")
    private IssueFieldOptionConfiguration config;

    public IssueFieldOption id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier for the option. This is only unique within the select field's set of options.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public IssueFieldOption value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="The option's name, which is displayed in Jira.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public IssueFieldOption properties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    public IssueFieldOption putPropertiesItem(String key, Object propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @ApiModelProperty(value="The properties of the object, as arbitrary key-value pairs. These properties can be searched using JQL, if the extractions (see [Issue Field Option Property Index](https://developer.atlassian.com/cloud/jira/platform/modules/issue-field-option-property-index/)) are defined in the descriptor for the issue field module.")
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public IssueFieldOption config(IssueFieldOptionConfiguration config) {
        this.config = config;
        return this;
    }

    @ApiModelProperty(value="")
    public IssueFieldOptionConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(IssueFieldOptionConfiguration config) {
        this.config = config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueFieldOption issueFieldOption = (IssueFieldOption)o;
        return Objects.equals(this.id, issueFieldOption.id) && Objects.equals(this.value, issueFieldOption.value) && Objects.equals(this.properties, issueFieldOption.properties) && Objects.equals(this.config, issueFieldOption.config);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.value, this.properties, this.config);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueFieldOption {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

