/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.JsonNode;

@ApiModel(description="Lists of issues and entity properties. See [Entity properties](https://developer.atlassian.com/cloud/jira/platform/jira-entity-properties/) for more information.")
public class IssueEntityProperties {
    @JsonProperty(value="entitiesIds")
    private List<Long> entitiesIds = new ArrayList<Long>();
    @JsonProperty(value="properties")
    private Map<String, JsonNode> properties = new HashMap<String, JsonNode>();

    public IssueEntityProperties entitiesIds(List<Long> entitiesIds) {
        this.entitiesIds = entitiesIds;
        return this;
    }

    public IssueEntityProperties addEntitiesIdsItem(Long entitiesIdsItem) {
        if (this.entitiesIds == null) {
            this.entitiesIds = new ArrayList<Long>();
        }
        this.entitiesIds.add(entitiesIdsItem);
        return this;
    }

    @ApiModelProperty(value="A list of entity property IDs.")
    public List<Long> getEntitiesIds() {
        return this.entitiesIds;
    }

    public void setEntitiesIds(List<Long> entitiesIds) {
        this.entitiesIds = entitiesIds;
    }

    public IssueEntityProperties properties(Map<String, JsonNode> properties) {
        this.properties = properties;
        return this;
    }

    public IssueEntityProperties putPropertiesItem(String key, JsonNode propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, JsonNode>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @ApiModelProperty(value="A list of entity property keys and values.")
    public Map<String, JsonNode> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, JsonNode> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueEntityProperties issueEntityProperties = (IssueEntityProperties)o;
        return Objects.equals(this.entitiesIds, issueEntityProperties.entitiesIds) && Objects.equals(this.properties, issueEntityProperties.properties);
    }

    public int hashCode() {
        return Objects.hash(this.entitiesIds, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueEntityProperties {\n");
        sb.append("    entitiesIds: ").append(this.toIndentedString(this.entitiesIds)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

