/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.GroupLabel;

@ApiModel(description="A group found in a search.")
public class FoundGroup {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="html")
    private String html;
    @JsonProperty(value="labels")
    private List<GroupLabel> labels = new ArrayList<GroupLabel>();
    @JsonProperty(value="groupId")
    private String groupId;

    public FoundGroup name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the group.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FoundGroup html(String html) {
        this.html = html;
        return this;
    }

    @ApiModelProperty(value="The group name with the matched query string highlighted with the HTML bold tag.")
    public String getHtml() {
        return this.html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public FoundGroup labels(List<GroupLabel> labels) {
        this.labels = labels;
        return this;
    }

    public FoundGroup addLabelsItem(GroupLabel labelsItem) {
        if (this.labels == null) {
            this.labels = new ArrayList<GroupLabel>();
        }
        this.labels.add(labelsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<GroupLabel> getLabels() {
        return this.labels;
    }

    public void setLabels(List<GroupLabel> labels) {
        this.labels = labels;
    }

    public FoundGroup groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @ApiModelProperty(value="The ID of the group, if available, which uniquely identifies the group across all Atlassian products. For example, *952d12c3-5b5b-4d04-bb32-44d383afc4b2*.")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FoundGroup foundGroup = (FoundGroup)o;
        return Objects.equals(this.name, foundGroup.name) && Objects.equals(this.html, foundGroup.html) && Objects.equals(this.labels, foundGroup.labels) && Objects.equals(this.groupId, foundGroup.groupId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.html, this.labels, this.groupId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FoundGroup {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    html: ").append(this.toIndentedString(this.html)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

