/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.FilterSubscription;
import org.everit.atlassian.restclient.jiracloud.v3.model.SharePermission;
import org.everit.atlassian.restclient.jiracloud.v3.model.User;

@ApiModel(description="Details of a filter.")
public class FilterDetails {
    @JsonProperty(value="self")
    private URI self;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="owner")
    private User owner;
    @JsonProperty(value="jql")
    private String jql;
    @JsonProperty(value="viewUrl")
    private URI viewUrl;
    @JsonProperty(value="searchUrl")
    private URI searchUrl;
    @JsonProperty(value="favourite")
    private Boolean favourite;
    @JsonProperty(value="favouritedCount")
    private Long favouritedCount;
    @JsonProperty(value="sharePermissions")
    private List<SharePermission> sharePermissions = new ArrayList<SharePermission>();
    @JsonProperty(value="subscriptions")
    private List<FilterSubscription> subscriptions = new ArrayList<FilterSubscription>();

    @ApiModelProperty(value="The URL of the filter.")
    public URI getSelf() {
        return this.self;
    }

    @ApiModelProperty(value="The unique identifier for the filter.")
    public String getId() {
        return this.id;
    }

    public FilterDetails name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the filter. Must be unique.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FilterDetails description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A description of the filter.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(value="The user who owns the filter. This is defaulted to the creator of the filter, however Jira administrators can change the owner of a shared filter in the admin settings.")
    public User getOwner() {
        return this.owner;
    }

    @ApiModelProperty(value="The JQL query for the filter. For example, *project = SSP AND issuetype = Bug*.")
    public String getJql() {
        return this.jql;
    }

    @ApiModelProperty(value="A URL to view the filter results in Jira, using the ID of the filter. For example, *https://your-domain.atlassian.net/issues/?filter=10100*.")
    public URI getViewUrl() {
        return this.viewUrl;
    }

    @ApiModelProperty(value="A URL to view the filter results in Jira, using the [Search for issues using JQL](#api-rest-api-3-filter-search-get) operation with the filter's JQL string to return the filter results. For example, *https://your-domain.atlassian.net/rest/api/3/search?jql=project+%3D+SSP+AND+issuetype+%3D+Bug*.")
    public URI getSearchUrl() {
        return this.searchUrl;
    }

    @ApiModelProperty(value="Whether the filter is selected as a favorite by any users, not including the filter owner.")
    public Boolean getFavourite() {
        return this.favourite;
    }

    @ApiModelProperty(value="The count of how many users have selected this filter as a favorite, including the filter owner.")
    public Long getFavouritedCount() {
        return this.favouritedCount;
    }

    public FilterDetails sharePermissions(List<SharePermission> sharePermissions) {
        this.sharePermissions = sharePermissions;
        return this;
    }

    public FilterDetails addSharePermissionsItem(SharePermission sharePermissionsItem) {
        if (this.sharePermissions == null) {
            this.sharePermissions = new ArrayList<SharePermission>();
        }
        this.sharePermissions.add(sharePermissionsItem);
        return this;
    }

    @ApiModelProperty(value="The groups and projects that the filter is shared with. This can be specified when updating a filter, but not when creating a filter.")
    public List<SharePermission> getSharePermissions() {
        return this.sharePermissions;
    }

    public void setSharePermissions(List<SharePermission> sharePermissions) {
        this.sharePermissions = sharePermissions;
    }

    @ApiModelProperty(value="The users that are subscribed to the filter.")
    public List<FilterSubscription> getSubscriptions() {
        return this.subscriptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterDetails filterDetails = (FilterDetails)o;
        return Objects.equals(this.self, filterDetails.self) && Objects.equals(this.id, filterDetails.id) && Objects.equals(this.name, filterDetails.name) && Objects.equals(this.description, filterDetails.description) && Objects.equals(this.owner, filterDetails.owner) && Objects.equals(this.jql, filterDetails.jql) && Objects.equals(this.viewUrl, filterDetails.viewUrl) && Objects.equals(this.searchUrl, filterDetails.searchUrl) && Objects.equals(this.favourite, filterDetails.favourite) && Objects.equals(this.favouritedCount, filterDetails.favouritedCount) && Objects.equals(this.sharePermissions, filterDetails.sharePermissions) && Objects.equals(this.subscriptions, filterDetails.subscriptions);
    }

    public int hashCode() {
        return Objects.hash(this.self, this.id, this.name, this.description, this.owner, this.jql, this.viewUrl, this.searchUrl, this.favourite, this.favouritedCount, this.sharePermissions, this.subscriptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FilterDetails {\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    jql: ").append(this.toIndentedString(this.jql)).append("\n");
        sb.append("    viewUrl: ").append(this.toIndentedString(this.viewUrl)).append("\n");
        sb.append("    searchUrl: ").append(this.toIndentedString(this.searchUrl)).append("\n");
        sb.append("    favourite: ").append(this.toIndentedString(this.favourite)).append("\n");
        sb.append("    favouritedCount: ").append(this.toIndentedString(this.favouritedCount)).append("\n");
        sb.append("    sharePermissions: ").append(this.toIndentedString(this.sharePermissions)).append("\n");
        sb.append("    subscriptions: ").append(this.toIndentedString(this.subscriptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

