/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.UserDetails;

@ApiModel(description="Details about an attachment.")
public class Attachment {
    @JsonProperty(value="self")
    private String self;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="filename")
    private String filename;
    @JsonProperty(value="author")
    private UserDetails author;
    @JsonProperty(value="created")
    private OffsetDateTime created;
    @JsonProperty(value="size")
    private Long size;
    @JsonProperty(value="mimeType")
    private String mimeType;
    @JsonProperty(value="content")
    private String content;
    @JsonProperty(value="thumbnail")
    private String thumbnail;
    private HashMap<String, Object> additionalProperties_ = new HashMap();

    @ApiModelProperty(value="The URL of the attachment details response.")
    public String getSelf() {
        return this.self;
    }

    @ApiModelProperty(value="The ID of the attachment.")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(value="The file name of the attachment.")
    public String getFilename() {
        return this.filename;
    }

    @ApiModelProperty(value="Details of the user who added the attachment.")
    public UserDetails getAuthor() {
        return this.author;
    }

    @ApiModelProperty(value="The datetime the attachment was created.")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @ApiModelProperty(value="The size of the attachment.")
    public Long getSize() {
        return this.size;
    }

    @ApiModelProperty(value="The MIME type of the attachment.")
    public String getMimeType() {
        return this.mimeType;
    }

    @ApiModelProperty(value="The content of the attachment.")
    public String getContent() {
        return this.content;
    }

    @ApiModelProperty(value="The URL of a thumbnail representing the attachment.")
    public String getThumbnail() {
        return this.thumbnail;
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.additionalProperties_;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.additionalProperties_.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attachment attachment = (Attachment)o;
        return Objects.equals(this.self, attachment.self) && Objects.equals(this.id, attachment.id) && Objects.equals(this.filename, attachment.filename) && Objects.equals(this.author, attachment.author) && Objects.equals(this.created, attachment.created) && Objects.equals(this.size, attachment.size) && Objects.equals(this.mimeType, attachment.mimeType) && Objects.equals(this.content, attachment.content) && Objects.equals(this.thumbnail, attachment.thumbnail) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.self, this.id, this.filename, this.author, this.created, this.size, this.mimeType, this.content, this.thumbnail, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Attachment {\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    filename: ").append(this.toIndentedString(this.filename)).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    mimeType: ").append(this.toIndentedString(this.mimeType)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    thumbnail: ").append(this.toIndentedString(this.thumbnail)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties_)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

