/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.ScreenTypes;

@ApiModel(description="Details of a screen scheme.")
public class ScreenSchemeDetails {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="screens")
    private ScreenTypes screens;

    public ScreenSchemeDetails name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the screen scheme. The name must be unique. The maximum length is 255 characters.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ScreenSchemeDetails description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the screen scheme. The maximum length is 255 characters.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ScreenSchemeDetails screens(ScreenTypes screens) {
        this.screens = screens;
        return this;
    }

    @ApiModelProperty(value="The IDs of the screens for the screen types of the screen scheme. Only screens used in classic projects are accepted.")
    public ScreenTypes getScreens() {
        return this.screens;
    }

    public void setScreens(ScreenTypes screens) {
        this.screens = screens;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScreenSchemeDetails screenSchemeDetails = (ScreenSchemeDetails)o;
        return Objects.equals(this.name, screenSchemeDetails.name) && Objects.equals(this.description, screenSchemeDetails.description) && Objects.equals(this.screens, screenSchemeDetails.screens);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.screens);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScreenSchemeDetails {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    screens: ").append(this.toIndentedString(this.screens)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

