/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.everit.atlassian.restclient.jiracloud.v2.model.Scope;

@ApiModel(description="Details about an issue type.")
public class IssueTypeDetails {
    @JsonProperty(value="self")
    private String self;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="iconUrl")
    private String iconUrl;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="subtask")
    private Boolean subtask;
    @JsonProperty(value="avatarId")
    private Long avatarId;
    @JsonProperty(value="entityId")
    private UUID entityId;
    @JsonProperty(value="scope")
    private Scope scope;

    @ApiModelProperty(value="The URL of these issue type details.")
    public String getSelf() {
        return this.self;
    }

    @ApiModelProperty(value="The ID of the issue type.")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(value="The description of the issue type.")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(value="The URL of the issue type's avatar.")
    public String getIconUrl() {
        return this.iconUrl;
    }

    @ApiModelProperty(value="The name of the issue type.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="Whether this issue type is used to create subtasks.")
    public Boolean getSubtask() {
        return this.subtask;
    }

    @ApiModelProperty(value="The ID of the issue type's avatar.")
    public Long getAvatarId() {
        return this.avatarId;
    }

    @ApiModelProperty(value="Unique ID for next-gen projects.")
    public UUID getEntityId() {
        return this.entityId;
    }

    @ApiModelProperty(value="Details of the next-gen projects the issue type is available in.")
    public Scope getScope() {
        return this.scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueTypeDetails issueTypeDetails = (IssueTypeDetails)o;
        return Objects.equals(this.self, issueTypeDetails.self) && Objects.equals(this.id, issueTypeDetails.id) && Objects.equals(this.description, issueTypeDetails.description) && Objects.equals(this.iconUrl, issueTypeDetails.iconUrl) && Objects.equals(this.name, issueTypeDetails.name) && Objects.equals(this.subtask, issueTypeDetails.subtask) && Objects.equals(this.avatarId, issueTypeDetails.avatarId) && Objects.equals(this.entityId, issueTypeDetails.entityId) && Objects.equals(this.scope, issueTypeDetails.scope);
    }

    public int hashCode() {
        return Objects.hash(this.self, this.id, this.description, this.iconUrl, this.name, this.subtask, this.avatarId, this.entityId, this.scope);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueTypeDetails {\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    iconUrl: ").append(this.toIndentedString(this.iconUrl)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    subtask: ").append(this.toIndentedString(this.subtask)).append("\n");
        sb.append("    avatarId: ").append(this.toIndentedString(this.avatarId)).append("\n");
        sb.append("    entityId: ").append(this.toIndentedString(this.entityId)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

