/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.IssueFieldOptionScopeBean;

@ApiModel(description="Details of the projects the option is available in.")
public class IssueFieldOptionConfiguration {
    @JsonProperty(value="scope")
    private IssueFieldOptionScopeBean scope;
    @JsonProperty(value="attributes")
    private List<AttributesEnum> attributes = new ArrayList<AttributesEnum>();

    public IssueFieldOptionConfiguration scope(IssueFieldOptionScopeBean scope) {
        this.scope = scope;
        return this;
    }

    @ApiModelProperty(value="Defines the projects that the option is available in. If the scope is not defined, then the option is available in all projects.")
    public IssueFieldOptionScopeBean getScope() {
        return this.scope;
    }

    public void setScope(IssueFieldOptionScopeBean scope) {
        this.scope = scope;
    }

    public IssueFieldOptionConfiguration attributes(List<AttributesEnum> attributes) {
        this.attributes = attributes;
        return this;
    }

    public IssueFieldOptionConfiguration addAttributesItem(AttributesEnum attributesItem) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<AttributesEnum>();
        }
        this.attributes.add(attributesItem);
        return this;
    }

    @ApiModelProperty(value="DEPRECATED")
    public List<AttributesEnum> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<AttributesEnum> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueFieldOptionConfiguration issueFieldOptionConfiguration = (IssueFieldOptionConfiguration)o;
        return Objects.equals(this.scope, issueFieldOptionConfiguration.scope) && Objects.equals(this.attributes, issueFieldOptionConfiguration.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.scope, this.attributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueFieldOptionConfiguration {\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AttributesEnum {
        NOTSELECTABLE("notSelectable"),
        DEFAULTVALUE("defaultValue");

        private String value;

        private AttributesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AttributesEnum fromValue(String value) {
            for (AttributesEnum b : AttributesEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

