/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.IdBean;
import org.everit.atlassian.restclient.jiracloud.v2.model.PermissionScheme;
import org.everit.atlassian.restclient.jiracloud.v2.model.ProjectIssueSecurityLevels;
import org.everit.atlassian.restclient.jiracloud.v2.model.SecurityScheme;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class ProjectPermissionSchemesApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.com";
    private static final TypeReference<PermissionScheme> returnType_assignPermissionScheme = new TypeReference<PermissionScheme>(){};
    private static final TypeReference<PermissionScheme> returnType_getAssignedPermissionScheme = new TypeReference<PermissionScheme>(){};
    private static final TypeReference<SecurityScheme> returnType_getProjectIssueSecurityScheme = new TypeReference<SecurityScheme>(){};
    private static final TypeReference<ProjectIssueSecurityLevels> returnType_getSecurityLevelsForProject = new TypeReference<ProjectIssueSecurityLevels>(){};
    private final RestClient restClient;

    public ProjectPermissionSchemesApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<PermissionScheme> assignPermissionScheme(String projectKeyOrId, IdBean idBean, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project/{projectKeyOrId}/permissionscheme");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectKeyOrId", String.valueOf(projectKeyOrId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(idBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_assignPermissionScheme);
    }

    public Single<PermissionScheme> getAssignedPermissionScheme(String projectKeyOrId, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project/{projectKeyOrId}/permissionscheme");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectKeyOrId", String.valueOf(projectKeyOrId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAssignedPermissionScheme);
    }

    public Single<SecurityScheme> getProjectIssueSecurityScheme(String projectKeyOrId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project/{projectKeyOrId}/issuesecuritylevelscheme");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectKeyOrId", String.valueOf(projectKeyOrId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getProjectIssueSecurityScheme);
    }

    public Single<ProjectIssueSecurityLevels> getSecurityLevelsForProject(String projectKeyOrId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project/{projectKeyOrId}/securitylevel");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectKeyOrId", String.valueOf(projectKeyOrId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getSecurityLevelsForProject);
    }
}

