/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.RemoteIssueLink;
import org.everit.atlassian.restclient.jiracloud.v2.model.RemoteIssueLinkIdentifies;
import org.everit.atlassian.restclient.jiracloud.v2.model.RemoteIssueLinkRequest;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class IssueRemoteLinksApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.com";
    private static final TypeReference<RemoteIssueLinkIdentifies> returnType_createOrUpdateRemoteIssueLink = new TypeReference<RemoteIssueLinkIdentifies>(){};
    private static final TypeReference<RemoteIssueLink> returnType_getRemoteIssueLinkById = new TypeReference<RemoteIssueLink>(){};
    private static final TypeReference<RemoteIssueLink> returnType_getRemoteIssueLinks = new TypeReference<RemoteIssueLink>(){};
    private static final TypeReference<Object> returnType_updateRemoteIssueLink = new TypeReference<Object>(){};
    private final RestClient restClient;

    public IssueRemoteLinksApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<RemoteIssueLinkIdentifies> createOrUpdateRemoteIssueLink(String issueIdOrKey, RemoteIssueLinkRequest requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/remotelink");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createOrUpdateRemoteIssueLink);
    }

    public Completable deleteRemoteIssueLinkByGlobalId(String issueIdOrKey, String globalId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/remotelink");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        queryParams.put("globalId", Collections.singleton(String.valueOf(globalId)));
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Completable deleteRemoteIssueLinkById(String issueIdOrKey, String linkId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/remotelink/{linkId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        pathParams.put("linkId", String.valueOf(linkId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<RemoteIssueLink> getRemoteIssueLinkById(String issueIdOrKey, String linkId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/remotelink/{linkId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        pathParams.put("linkId", String.valueOf(linkId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getRemoteIssueLinkById);
    }

    public Single<RemoteIssueLink> getRemoteIssueLinks(String issueIdOrKey, Optional<String> globalId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/remotelink");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (globalId.isPresent()) {
            queryParams.put("globalId", Collections.singleton(String.valueOf(globalId.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getRemoteIssueLinks);
    }

    public Single<Object> updateRemoteIssueLink(String issueIdOrKey, String linkId, RemoteIssueLinkRequest requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/remotelink/{linkId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        pathParams.put("linkId", String.valueOf(linkId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateRemoteIssueLink);
    }
}

