/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Single;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.FieldConfigurationSchemeProjectAssociation;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanFieldConfiguration;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanFieldConfigurationIssueTypeItem;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanFieldConfigurationItem;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanFieldConfigurationScheme;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanFieldConfigurationSchemeProjects;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestClientUtil;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class IssueFieldConfigurationsApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.com";
    private static final TypeReference<Object> returnType_assignFieldConfigurationSchemeToProject = new TypeReference<Object>(){};
    private static final TypeReference<PageBeanFieldConfigurationScheme> returnType_getAllFieldConfigurationSchemes = new TypeReference<PageBeanFieldConfigurationScheme>(){};
    private static final TypeReference<PageBeanFieldConfiguration> returnType_getAllFieldConfigurations = new TypeReference<PageBeanFieldConfiguration>(){};
    private static final TypeReference<PageBeanFieldConfigurationItem> returnType_getFieldConfigurationItems = new TypeReference<PageBeanFieldConfigurationItem>(){};
    private static final TypeReference<PageBeanFieldConfigurationIssueTypeItem> returnType_getFieldConfigurationSchemeMappings = new TypeReference<PageBeanFieldConfigurationIssueTypeItem>(){};
    private static final TypeReference<PageBeanFieldConfigurationSchemeProjects> returnType_getFieldConfigurationSchemeProjectMapping = new TypeReference<PageBeanFieldConfigurationSchemeProjects>(){};
    private final RestClient restClient;

    public IssueFieldConfigurationsApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<Object> assignFieldConfigurationSchemeToProject(FieldConfigurationSchemeProjectAssociation fieldConfigurationSchemeProjectAssociation, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/fieldconfigurationscheme/project");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(fieldConfigurationSchemeProjectAssociation));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_assignFieldConfigurationSchemeToProject);
    }

    public Single<PageBeanFieldConfigurationScheme> getAllFieldConfigurationSchemes(Optional<Long> startAt, Optional<Integer> maxResults, Optional<List<Long>> id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/fieldconfigurationscheme");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (id.isPresent()) {
            queryParams.put("id", RestClientUtil.objectCollectionToStringCollection((Collection)id.get()));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAllFieldConfigurationSchemes);
    }

    public Single<PageBeanFieldConfiguration> getAllFieldConfigurations(Optional<Long> startAt, Optional<Integer> maxResults, Optional<List<Long>> id, Optional<Boolean> isDefault, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/fieldconfiguration");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (id.isPresent()) {
            queryParams.put("id", RestClientUtil.objectCollectionToStringCollection((Collection)id.get()));
        }
        if (isDefault.isPresent()) {
            queryParams.put("isDefault", Collections.singleton(String.valueOf(isDefault.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAllFieldConfigurations);
    }

    public Single<PageBeanFieldConfigurationItem> getFieldConfigurationItems(Long id, Optional<Long> startAt, Optional<Integer> maxResults, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/fieldconfiguration/{id}/fields");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getFieldConfigurationItems);
    }

    public Single<PageBeanFieldConfigurationIssueTypeItem> getFieldConfigurationSchemeMappings(Optional<Long> startAt, Optional<Integer> maxResults, Optional<List<Long>> fieldConfigurationSchemeId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/fieldconfigurationscheme/mapping");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (fieldConfigurationSchemeId.isPresent()) {
            queryParams.put("fieldConfigurationSchemeId", RestClientUtil.objectCollectionToStringCollection((Collection)fieldConfigurationSchemeId.get()));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getFieldConfigurationSchemeMappings);
    }

    public Single<PageBeanFieldConfigurationSchemeProjects> getFieldConfigurationSchemeProjectMapping(List<Long> projectId, Optional<Long> startAt, Optional<Integer> maxResults, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/fieldconfigurationscheme/project");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        queryParams.put("projectId", RestClientUtil.objectCollectionToStringCollection(projectId));
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getFieldConfigurationSchemeProjectMapping);
    }
}

