/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.Dashboard;
import org.everit.atlassian.restclient.jiracloud.v2.model.DashboardDetails;
import org.everit.atlassian.restclient.jiracloud.v2.model.EntityProperty;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanDashboard;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageOfDashboards;
import org.everit.atlassian.restclient.jiracloud.v2.model.PropertyKeys;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class DashboardsApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.com";
    private static final TypeReference<Dashboard> returnType_copyDashboard = new TypeReference<Dashboard>(){};
    private static final TypeReference<Dashboard> returnType_createDashboard = new TypeReference<Dashboard>(){};
    private static final TypeReference<PageOfDashboards> returnType_getAllDashboards = new TypeReference<PageOfDashboards>(){};
    private static final TypeReference<Dashboard> returnType_getDashboard = new TypeReference<Dashboard>(){};
    private static final TypeReference<EntityProperty> returnType_getDashboardItemProperty = new TypeReference<EntityProperty>(){};
    private static final TypeReference<PropertyKeys> returnType_getDashboardItemPropertyKeys = new TypeReference<PropertyKeys>(){};
    private static final TypeReference<PageBeanDashboard> returnType_getDashboardsPaginated = new TypeReference<PageBeanDashboard>(){};
    private static final TypeReference<Object> returnType_setDashboardItemProperty = new TypeReference<Object>(){};
    private static final TypeReference<Dashboard> returnType_updateDashboard = new TypeReference<Dashboard>(){};
    private final RestClient restClient;

    public DashboardsApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<Dashboard> copyDashboard(String id, DashboardDetails dashboardDetails, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/dashboard/{id}/copy");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(dashboardDetails));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_copyDashboard);
    }

    public Single<Dashboard> createDashboard(DashboardDetails dashboardDetails, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/dashboard");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(dashboardDetails));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createDashboard);
    }

    public Completable deleteDashboard(String id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/dashboard/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Completable deleteDashboardItemProperty(String dashboardId, String itemId, String propertyKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/dashboard/{dashboardId}/items/{itemId}/properties/{propertyKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("dashboardId", String.valueOf(dashboardId));
        pathParams.put("itemId", String.valueOf(itemId));
        pathParams.put("propertyKey", String.valueOf(propertyKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<PageOfDashboards> getAllDashboards(Optional<String> filter, Optional<Integer> startAt, Optional<Integer> maxResults, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/dashboard");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (filter.isPresent()) {
            queryParams.put("filter", Collections.singleton(String.valueOf(filter.get())));
        }
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAllDashboards);
    }

    public Single<Dashboard> getDashboard(String id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/dashboard/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getDashboard);
    }

    public Single<EntityProperty> getDashboardItemProperty(String dashboardId, String itemId, String propertyKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/dashboard/{dashboardId}/items/{itemId}/properties/{propertyKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("dashboardId", String.valueOf(dashboardId));
        pathParams.put("itemId", String.valueOf(itemId));
        pathParams.put("propertyKey", String.valueOf(propertyKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getDashboardItemProperty);
    }

    public Single<PropertyKeys> getDashboardItemPropertyKeys(String dashboardId, String itemId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/dashboard/{dashboardId}/items/{itemId}/properties");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("dashboardId", String.valueOf(dashboardId));
        pathParams.put("itemId", String.valueOf(itemId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getDashboardItemPropertyKeys);
    }

    public Single<PageBeanDashboard> getDashboardsPaginated(Optional<String> dashboardName, Optional<String> accountId, Optional<String> owner, Optional<String> groupname, Optional<Long> projectId, Optional<String> orderBy, Optional<Long> startAt, Optional<Integer> maxResults, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/dashboard/search");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (dashboardName.isPresent()) {
            queryParams.put("dashboardName", Collections.singleton(String.valueOf(dashboardName.get())));
        }
        if (accountId.isPresent()) {
            queryParams.put("accountId", Collections.singleton(String.valueOf(accountId.get())));
        }
        if (owner.isPresent()) {
            queryParams.put("owner", Collections.singleton(String.valueOf(owner.get())));
        }
        if (groupname.isPresent()) {
            queryParams.put("groupname", Collections.singleton(String.valueOf(groupname.get())));
        }
        if (projectId.isPresent()) {
            queryParams.put("projectId", Collections.singleton(String.valueOf(projectId.get())));
        }
        if (orderBy.isPresent()) {
            queryParams.put("orderBy", Collections.singleton(String.valueOf(orderBy.get())));
        }
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getDashboardsPaginated);
    }

    public Single<Object> setDashboardItemProperty(String dashboardId, String itemId, String propertyKey, Object body, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/dashboard/{dashboardId}/items/{itemId}/properties/{propertyKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("dashboardId", String.valueOf(dashboardId));
        pathParams.put("itemId", String.valueOf(itemId));
        pathParams.put("propertyKey", String.valueOf(propertyKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(body));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_setDashboardItemProperty);
    }

    public Single<Dashboard> updateDashboard(String id, DashboardDetails dashboardDetails, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/dashboard/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(dashboardDetails));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateDashboard);
    }
}

