/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.JqlQueryFieldEntityProperty;

@ApiModel(description="A field used in a JQL query. See [Advanced searching - fields reference](https://confluence.atlassian.com/x/dAiiLQ) for more information about fields in JQL queries.")
public class JqlQueryField {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="property")
    private List<JqlQueryFieldEntityProperty> property = new ArrayList<JqlQueryFieldEntityProperty>();

    public JqlQueryField name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the field.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JqlQueryField property(List<JqlQueryFieldEntityProperty> property) {
        this.property = property;
        return this;
    }

    public JqlQueryField addPropertyItem(JqlQueryFieldEntityProperty propertyItem) {
        if (this.property == null) {
            this.property = new ArrayList<JqlQueryFieldEntityProperty>();
        }
        this.property.add(propertyItem);
        return this;
    }

    @ApiModelProperty(value="When the field refers to a value in an entity property, details of the entity property value.")
    public List<JqlQueryFieldEntityProperty> getProperty() {
        return this.property;
    }

    public void setProperty(List<JqlQueryFieldEntityProperty> property) {
        this.property = property;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JqlQueryField jqlQueryField = (JqlQueryField)o;
        return Objects.equals(this.name, jqlQueryField.name) && Objects.equals(this.property, jqlQueryField.property);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.property);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JqlQueryField {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    property: ").append(this.toIndentedString(this.property)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

