/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v3.model.DefaultWorkflow;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueTypeWorkflowMapping;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueTypesWorkflowMapping;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowScheme;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class WorkflowSchemeApi {
    private static final String DEFAULT_BASE_PATH = "http://localhost";
    private static final TypeReference<WorkflowScheme> returnType_createWorkflowScheme = new TypeReference<WorkflowScheme>(){};
    private static final TypeReference<WorkflowScheme> returnType_createWorkflowSchemeDraftFromParent = new TypeReference<WorkflowScheme>(){};
    private static final TypeReference<WorkflowScheme> returnType_deleteDefaultWorkflow = new TypeReference<WorkflowScheme>(){};
    private static final TypeReference<WorkflowScheme> returnType_deleteDraftDefaultWorkflow = new TypeReference<WorkflowScheme>(){};
    private static final TypeReference<WorkflowScheme> returnType_deleteWorkflowSchemeDraftIssueType = new TypeReference<WorkflowScheme>(){};
    private static final TypeReference<WorkflowScheme> returnType_deleteWorkflowSchemeIssueType = new TypeReference<WorkflowScheme>(){};
    private static final TypeReference<DefaultWorkflow> returnType_getDefaultWorkflow = new TypeReference<DefaultWorkflow>(){};
    private static final TypeReference<DefaultWorkflow> returnType_getDraftDefaultWorkflow = new TypeReference<DefaultWorkflow>(){};
    private static final TypeReference<IssueTypesWorkflowMapping> returnType_getDraftWorkflow = new TypeReference<IssueTypesWorkflowMapping>(){};
    private static final TypeReference<IssueTypesWorkflowMapping> returnType_getWorkflow = new TypeReference<IssueTypesWorkflowMapping>(){};
    private static final TypeReference<WorkflowScheme> returnType_getWorkflowScheme = new TypeReference<WorkflowScheme>(){};
    private static final TypeReference<WorkflowScheme> returnType_getWorkflowSchemeDraft = new TypeReference<WorkflowScheme>(){};
    private static final TypeReference<IssueTypeWorkflowMapping> returnType_getWorkflowSchemeDraftIssueType = new TypeReference<IssueTypeWorkflowMapping>(){};
    private static final TypeReference<IssueTypeWorkflowMapping> returnType_getWorkflowSchemeIssueType = new TypeReference<IssueTypeWorkflowMapping>(){};
    private static final TypeReference<WorkflowScheme> returnType_setWorkflowSchemeDraftIssueType = new TypeReference<WorkflowScheme>(){};
    private static final TypeReference<WorkflowScheme> returnType_setWorkflowSchemeIssueType = new TypeReference<WorkflowScheme>(){};
    private static final TypeReference<WorkflowScheme> returnType_updateDefaultWorkflow = new TypeReference<WorkflowScheme>(){};
    private static final TypeReference<WorkflowScheme> returnType_updateDraftDefaultWorkflow = new TypeReference<WorkflowScheme>(){};
    private static final TypeReference<WorkflowScheme> returnType_updateDraftWorkflowMapping = new TypeReference<WorkflowScheme>(){};
    private static final TypeReference<WorkflowScheme> returnType_updateWorkflowMapping = new TypeReference<WorkflowScheme>(){};
    private static final TypeReference<WorkflowScheme> returnType_updateWorkflowScheme = new TypeReference<WorkflowScheme>(){};
    private static final TypeReference<WorkflowScheme> returnType_updateWorkflowSchemeDraft = new TypeReference<WorkflowScheme>(){};
    private final RestClient restClient;

    public WorkflowSchemeApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<WorkflowScheme> createWorkflowScheme(WorkflowScheme workflowScheme, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(workflowScheme));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createWorkflowScheme);
    }

    public Single<WorkflowScheme> createWorkflowSchemeDraftFromParent(Long id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}/createdraft");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createWorkflowSchemeDraftFromParent);
    }

    public Single<WorkflowScheme> deleteDefaultWorkflow(Long id, Optional<Boolean> updateDraftIfNeeded, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}/default");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (updateDraftIfNeeded.isPresent()) {
            queryParams.put("updateDraftIfNeeded", Collections.singleton(String.valueOf(updateDraftIfNeeded.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_deleteDefaultWorkflow);
    }

    public Single<WorkflowScheme> deleteDraftDefaultWorkflow(Long id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}/draft/default");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_deleteDraftDefaultWorkflow);
    }

    public Completable deleteDraftWorkflowMapping(Long id, Optional<String> workflowName, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}/draft/workflow");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (workflowName.isPresent()) {
            queryParams.put("workflowName", Collections.singleton(String.valueOf(workflowName.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Completable deleteWorkflowMapping(Long id, Optional<String> workflowName, Optional<Boolean> updateDraftIfNeeded, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}/workflow");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (workflowName.isPresent()) {
            queryParams.put("workflowName", Collections.singleton(String.valueOf(workflowName.get())));
        }
        if (updateDraftIfNeeded.isPresent()) {
            queryParams.put("updateDraftIfNeeded", Collections.singleton(String.valueOf(updateDraftIfNeeded.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Completable deleteWorkflowScheme(Long id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Completable deleteWorkflowSchemeDraft(Long id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}/draft");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<WorkflowScheme> deleteWorkflowSchemeDraftIssueType(Long id, String issueType, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}/draft/issuetype/{issueType}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        pathParams.put("issueType", String.valueOf(issueType));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_deleteWorkflowSchemeDraftIssueType);
    }

    public Single<WorkflowScheme> deleteWorkflowSchemeIssueType(Long id, String issueType, Optional<Boolean> updateDraftIfNeeded, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}/issuetype/{issueType}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        pathParams.put("issueType", String.valueOf(issueType));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (updateDraftIfNeeded.isPresent()) {
            queryParams.put("updateDraftIfNeeded", Collections.singleton(String.valueOf(updateDraftIfNeeded.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_deleteWorkflowSchemeIssueType);
    }

    public Single<DefaultWorkflow> getDefaultWorkflow(Long id, Optional<Boolean> returnDraftIfExists, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}/default");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (returnDraftIfExists.isPresent()) {
            queryParams.put("returnDraftIfExists", Collections.singleton(String.valueOf(returnDraftIfExists.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getDefaultWorkflow);
    }

    public Single<DefaultWorkflow> getDraftDefaultWorkflow(Long id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}/draft/default");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getDraftDefaultWorkflow);
    }

    public Single<IssueTypesWorkflowMapping> getDraftWorkflow(Long id, Optional<String> workflowName, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}/draft/workflow");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (workflowName.isPresent()) {
            queryParams.put("workflowName", Collections.singleton(String.valueOf(workflowName.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getDraftWorkflow);
    }

    public Single<IssueTypesWorkflowMapping> getWorkflow(Long id, Optional<String> workflowName, Optional<Boolean> returnDraftIfExists, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}/workflow");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (workflowName.isPresent()) {
            queryParams.put("workflowName", Collections.singleton(String.valueOf(workflowName.get())));
        }
        if (returnDraftIfExists.isPresent()) {
            queryParams.put("returnDraftIfExists", Collections.singleton(String.valueOf(returnDraftIfExists.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getWorkflow);
    }

    public Single<WorkflowScheme> getWorkflowScheme(Long id, Optional<Boolean> returnDraftIfExists, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (returnDraftIfExists.isPresent()) {
            queryParams.put("returnDraftIfExists", Collections.singleton(String.valueOf(returnDraftIfExists.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getWorkflowScheme);
    }

    public Single<WorkflowScheme> getWorkflowSchemeDraft(Long id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}/draft");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getWorkflowSchemeDraft);
    }

    public Single<IssueTypeWorkflowMapping> getWorkflowSchemeDraftIssueType(Long id, String issueType, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}/draft/issuetype/{issueType}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        pathParams.put("issueType", String.valueOf(issueType));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getWorkflowSchemeDraftIssueType);
    }

    public Single<IssueTypeWorkflowMapping> getWorkflowSchemeIssueType(Long id, String issueType, Optional<Boolean> returnDraftIfExists, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}/issuetype/{issueType}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        pathParams.put("issueType", String.valueOf(issueType));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (returnDraftIfExists.isPresent()) {
            queryParams.put("returnDraftIfExists", Collections.singleton(String.valueOf(returnDraftIfExists.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getWorkflowSchemeIssueType);
    }

    public Single<WorkflowScheme> setWorkflowSchemeDraftIssueType(Long id, String issueType, IssueTypeWorkflowMapping issueTypeWorkflowMapping, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}/draft/issuetype/{issueType}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        pathParams.put("issueType", String.valueOf(issueType));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(issueTypeWorkflowMapping));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_setWorkflowSchemeDraftIssueType);
    }

    public Single<WorkflowScheme> setWorkflowSchemeIssueType(Long id, String issueType, IssueTypeWorkflowMapping issueTypeWorkflowMapping, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}/issuetype/{issueType}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        pathParams.put("issueType", String.valueOf(issueType));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(issueTypeWorkflowMapping));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_setWorkflowSchemeIssueType);
    }

    public Single<WorkflowScheme> updateDefaultWorkflow(Long id, DefaultWorkflow defaultWorkflow, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}/default");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(defaultWorkflow));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateDefaultWorkflow);
    }

    public Single<WorkflowScheme> updateDraftDefaultWorkflow(Long id, DefaultWorkflow defaultWorkflow, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}/draft/default");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(defaultWorkflow));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateDraftDefaultWorkflow);
    }

    public Single<WorkflowScheme> updateDraftWorkflowMapping(Long id, IssueTypesWorkflowMapping issueTypesWorkflowMapping, Optional<String> workflowName, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}/draft/workflow");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (workflowName.isPresent()) {
            queryParams.put("workflowName", Collections.singleton(String.valueOf(workflowName.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(issueTypesWorkflowMapping));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateDraftWorkflowMapping);
    }

    public Single<WorkflowScheme> updateWorkflowMapping(Long id, IssueTypesWorkflowMapping issueTypesWorkflowMapping, Optional<String> workflowName, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}/workflow");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (workflowName.isPresent()) {
            queryParams.put("workflowName", Collections.singleton(String.valueOf(workflowName.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(issueTypesWorkflowMapping));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateWorkflowMapping);
    }

    public Single<WorkflowScheme> updateWorkflowScheme(Long id, WorkflowScheme workflowScheme, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(workflowScheme));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateWorkflowScheme);
    }

    public Single<WorkflowScheme> updateWorkflowSchemeDraft(Long id, WorkflowScheme workflowScheme, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/workflowscheme/{id}/draft");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(workflowScheme));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateWorkflowSchemeDraft);
    }
}

