/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v3.model.ActorInputBean;
import org.everit.atlassian.restclient.jiracloud.v3.model.ActorsMap;
import org.everit.atlassian.restclient.jiracloud.v3.model.ProjectRole;
import org.everit.atlassian.restclient.jiracloud.v3.model.ProjectRoleActorsUpdateBean;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class ProjectRoleActorsApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.com";
    private static final TypeReference<ProjectRole> returnType_addActorUsers = new TypeReference<ProjectRole>(){};
    private static final TypeReference<ProjectRole> returnType_addProjectRoleActorsToRole = new TypeReference<ProjectRole>(){};
    private static final TypeReference<ProjectRole> returnType_deleteProjectRoleActorsFromRole = new TypeReference<ProjectRole>(){};
    private static final TypeReference<ProjectRole> returnType_getProjectRoleActorsForRole = new TypeReference<ProjectRole>(){};
    private static final TypeReference<ProjectRole> returnType_setActors = new TypeReference<ProjectRole>(){};
    private final RestClient restClient;

    public ProjectRoleActorsApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<ProjectRole> addActorUsers(String projectIdOrKey, Long id, ActorsMap actorsMap, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/{projectIdOrKey}/role/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(actorsMap));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_addActorUsers);
    }

    public Single<ProjectRole> addProjectRoleActorsToRole(Long id, ActorInputBean actorInputBean, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/role/{id}/actors");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(actorInputBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_addProjectRoleActorsToRole);
    }

    public Completable deleteActor(String projectIdOrKey, Long id, Optional<String> user, Optional<String> group, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/{projectIdOrKey}/role/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (user.isPresent()) {
            queryParams.put("user", Collections.singleton(String.valueOf(user.get())));
        }
        if (group.isPresent()) {
            queryParams.put("group", Collections.singleton(String.valueOf(group.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<ProjectRole> deleteProjectRoleActorsFromRole(Long id, Optional<String> user, Optional<String> group, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/role/{id}/actors");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (user.isPresent()) {
            queryParams.put("user", Collections.singleton(String.valueOf(user.get())));
        }
        if (group.isPresent()) {
            queryParams.put("group", Collections.singleton(String.valueOf(group.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_deleteProjectRoleActorsFromRole);
    }

    public Single<ProjectRole> getProjectRoleActorsForRole(Long id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/role/{id}/actors");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getProjectRoleActorsForRole);
    }

    public Single<ProjectRole> setActors(String projectIdOrKey, Long id, ProjectRoleActorsUpdateBean projectRoleActorsUpdateBean, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/{projectIdOrKey}/role/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(projectRoleActorsUpdateBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_setActors);
    }
}

